/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.parser.sql;

import com.google.common.cache.LoadingCache;
import org.apache.shardingsphere.infra.parser.cache.SQLStatementCacheBuilder;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserExecutor;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class SQLStatementParserEngine {
    private final SQLStatementParserExecutor sqlStatementParserExecutor;
    private final LoadingCache<String, SQLStatement> sqlStatementCache;

    public SQLStatementParserEngine(String databaseType, SQLParserRule sqlParserRule) {
        this.sqlStatementParserExecutor = new SQLStatementParserExecutor(databaseType, sqlParserRule);
        this.sqlStatementCache = SQLStatementCacheBuilder.build(sqlParserRule, databaseType);
    }

    public SQLStatement parse(String sql, boolean useCache) {
        return useCache ? (SQLStatement)this.sqlStatementCache.getUnchecked((Object)sql) : this.sqlStatementParserExecutor.parse(sql);
    }
}

