/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.engine;

import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.infra.rewrite.engine.result.GenericSQLRewriteResult;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteUnit;
import org.apache.shardingsphere.infra.rewrite.sql.impl.DefaultSQLBuilder;
import org.apache.shardingsphere.sqltranslator.rule.SQLTranslatorRule;

public final class GenericSQLRewriteEngine {
    private final SQLTranslatorRule translatorRule;
    private final DatabaseType protocolType;
    private final Map<String, DatabaseType> storageTypes;

    public GenericSQLRewriteResult rewrite(SQLRewriteContext sqlRewriteContext) {
        String sql = this.translatorRule.translate(new DefaultSQLBuilder(sqlRewriteContext).toSQL(), sqlRewriteContext.getSqlStatementContext().getSqlStatement(), this.protocolType, !this.storageTypes.isEmpty() ? this.storageTypes.values().iterator().next() : this.protocolType);
        return new GenericSQLRewriteResult(new SQLRewriteUnit(sql, sqlRewriteContext.getParameterBuilder().getParameters()));
    }

    @Generated
    public GenericSQLRewriteEngine(SQLTranslatorRule translatorRule, DatabaseType protocolType, Map<String, DatabaseType> storageTypes) {
        this.translatorRule = translatorRule;
        this.protocolType = protocolType;
        this.storageTypes = storageTypes;
    }
}

