/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContextDecorator;
import org.apache.shardingsphere.infra.rewrite.engine.GenericSQLRewriteEngine;
import org.apache.shardingsphere.infra.rewrite.engine.RouteSQLRewriteEngine;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteResult;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.util.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.sqltranslator.rule.SQLTranslatorRule;

public final class SQLRewriteEntry {
    private final ShardingSphereDatabase database;
    private final ShardingSphereRuleMetaData globalRuleMetaData;
    private final ConfigurationProperties props;
    private final Map<ShardingSphereRule, SQLRewriteContextDecorator> decorators;

    public SQLRewriteEntry(ShardingSphereDatabase database, ShardingSphereRuleMetaData globalRuleMetaData, ConfigurationProperties props) {
        this.database = database;
        this.globalRuleMetaData = globalRuleMetaData;
        this.props = props;
        this.decorators = OrderedSPILoader.getServices(SQLRewriteContextDecorator.class, (Collection)database.getRuleMetaData().getRules());
    }

    public SQLRewriteResult rewrite(String sql, List<Object> params, SQLStatementContext sqlStatementContext, RouteContext routeContext, ConnectionContext connectionContext, HintValueContext hintValueContext) {
        SQLRewriteContext sqlRewriteContext = this.createSQLRewriteContext(sql, params, sqlStatementContext, routeContext, connectionContext, hintValueContext);
        SQLTranslatorRule rule = (SQLTranslatorRule)this.globalRuleMetaData.getSingleRule(SQLTranslatorRule.class);
        DatabaseType protocolType = this.database.getProtocolType();
        Map storageTypes = this.database.getResourceMetaData().getStorageTypes();
        return routeContext.getRouteUnits().isEmpty() ? new GenericSQLRewriteEngine(rule, protocolType, storageTypes).rewrite(sqlRewriteContext) : new RouteSQLRewriteEngine(rule, protocolType, storageTypes).rewrite(sqlRewriteContext, routeContext);
    }

    private SQLRewriteContext createSQLRewriteContext(String sql, List<Object> params, SQLStatementContext sqlStatementContext, RouteContext routeContext, ConnectionContext connectionContext, HintValueContext hintValueContext) {
        SQLRewriteContext result = new SQLRewriteContext(this.database.getName(), this.database.getSchemas(), sqlStatementContext, sql, params, connectionContext, hintValueContext);
        this.decorate(this.decorators, result, routeContext, hintValueContext);
        result.generateSQLTokens();
        return result;
    }

    private void decorate(Map<ShardingSphereRule, SQLRewriteContextDecorator> decorators, SQLRewriteContext sqlRewriteContext, RouteContext routeContext, HintValueContext hintValueContext) {
        if (hintValueContext.isSkipSQLRewrite()) {
            return;
        }
        for (Map.Entry<ShardingSphereRule, SQLRewriteContextDecorator> entry : decorators.entrySet()) {
            entry.getValue().decorate(entry.getKey(), this.props, sqlRewriteContext, routeContext);
        }
    }
}

