/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.RouteUnitAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.Substitutable;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class SubstitutableColumnNameToken
extends SQLToken
implements Substitutable,
RouteUnitAware {
    private static final String COLUMN_NAME_SPLITTER = ", ";
    private final int stopIndex;
    private final Collection<Projection> projections;
    private final boolean lastColumn;
    private final QuoteCharacter quoteCharacter;

    public SubstitutableColumnNameToken(int startIndex, int stopIndex, Collection<Projection> projections) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.lastColumn = false;
        this.quoteCharacter = QuoteCharacter.NONE;
        this.projections = projections;
    }

    public SubstitutableColumnNameToken(int startIndex, int stopIndex, Collection<Projection> projections, boolean lastColumn) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.lastColumn = lastColumn;
        this.quoteCharacter = QuoteCharacter.NONE;
        this.projections = projections;
    }

    public SubstitutableColumnNameToken(int startIndex, int stopIndex, Collection<Projection> projections, QuoteCharacter quoteCharacter) {
        super(startIndex);
        this.stopIndex = stopIndex;
        this.lastColumn = false;
        this.quoteCharacter = quoteCharacter;
        this.projections = projections;
    }

    @Override
    public String toString(RouteUnit routeUnit) {
        HashMap<String, String> logicAndActualTables = new HashMap<String, String>();
        if (null != routeUnit) {
            logicAndActualTables.putAll(this.getLogicAndActualTables(routeUnit));
        }
        StringBuilder result = new StringBuilder();
        int count = 0;
        for (Projection each : this.projections) {
            if (0 == count && !this.lastColumn) {
                result.append(this.getColumnExpression(each, logicAndActualTables));
            } else {
                result.append(COLUMN_NAME_SPLITTER).append(this.getColumnExpression(each, logicAndActualTables));
            }
            ++count;
        }
        return result.toString();
    }

    private Map<String, String> getLogicAndActualTables(RouteUnit routeUnit) {
        if (null == routeUnit) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (RouteMapper each : routeUnit.getTableMappers()) {
            result.put(each.getLogicName().toLowerCase(), each.getActualName());
        }
        return result;
    }

    private String getColumnExpression(Projection projection, Map<String, String> logicActualTableNames) {
        StringBuilder builder = new StringBuilder();
        if (projection instanceof ColumnProjection) {
            SubstitutableColumnNameToken.appendColumnProjection((ColumnProjection)projection, logicActualTableNames, builder);
        } else {
            builder.append(this.quoteCharacter.wrap(projection.getColumnLabel()));
        }
        return builder.toString();
    }

    private static void appendColumnProjection(ColumnProjection columnProjection, Map<String, String> logicActualTableNames, StringBuilder builder) {
        if (columnProjection.getOwner().isPresent()) {
            Optional owner = columnProjection.getOwner();
            String lowerCaseOwner = ((IdentifierValue)owner.get()).getValue().toLowerCase();
            builder.append(((IdentifierValue)owner.get()).getQuoteCharacter().wrap(logicActualTableNames.getOrDefault(lowerCaseOwner, ((IdentifierValue)owner.get()).getValue()))).append('.');
        }
        builder.append(columnProjection.getName().getValueWithQuoteCharacters());
        if (columnProjection.getAlias().isPresent()) {
            builder.append(" AS ").append(((IdentifierValue)columnProjection.getAlias().get()).getValueWithQuoteCharacters());
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubstitutableColumnNameToken)) {
            return false;
        }
        SubstitutableColumnNameToken other = (SubstitutableColumnNameToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStopIndex() != other.getStopIndex()) {
            return false;
        }
        if (this.lastColumn != other.lastColumn) {
            return false;
        }
        Collection<Projection> this$projections = this.projections;
        Collection<Projection> other$projections = other.projections;
        if (this$projections == null ? other$projections != null : !((Object)this$projections).equals(other$projections)) {
            return false;
        }
        QuoteCharacter this$quoteCharacter = this.quoteCharacter;
        QuoteCharacter other$quoteCharacter = other.quoteCharacter;
        return !(this$quoteCharacter == null ? other$quoteCharacter != null : !this$quoteCharacter.equals(other$quoteCharacter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubstitutableColumnNameToken;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStopIndex();
        result = result * 59 + (this.lastColumn ? 79 : 97);
        Collection<Projection> $projections = this.projections;
        result = result * 59 + ($projections == null ? 43 : ((Object)$projections).hashCode());
        QuoteCharacter $quoteCharacter = this.quoteCharacter;
        result = result * 59 + ($quoteCharacter == null ? 43 : $quoteCharacter.hashCode());
        return result;
    }

    @Override
    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }
}

