/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.generator.generic;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.context.type.RemoveAvailable;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.RemoveToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public final class RemoveTokenGenerator
implements CollectionSQLTokenGenerator<SQLStatementContext> {
    @Override
    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        boolean containsRemoveSegment = false;
        if (sqlStatementContext instanceof RemoveAvailable) {
            containsRemoveSegment = !((RemoveAvailable)sqlStatementContext).getRemoveSegments().isEmpty();
        }
        boolean containsSchemaName = false;
        if (sqlStatementContext instanceof TableAvailable) {
            containsSchemaName = ((TableAvailable)sqlStatementContext).getTablesContext().getDatabaseName().isPresent();
        }
        boolean containsIndexSegment = false;
        if (sqlStatementContext instanceof IndexAvailable) {
            containsIndexSegment = !((IndexAvailable)sqlStatementContext).getIndexes().isEmpty();
        }
        return containsRemoveSegment || containsSchemaName || containsIndexSegment;
    }

    @Override
    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        if (sqlStatementContext instanceof RemoveAvailable && !((RemoveAvailable)sqlStatementContext).getRemoveSegments().isEmpty()) {
            result.addAll(this.generateRemoveAvailableSQLTokens(((RemoveAvailable)sqlStatementContext).getRemoveSegments()));
        }
        if (sqlStatementContext instanceof TableAvailable && ((TableAvailable)sqlStatementContext).getTablesContext().getDatabaseName().isPresent()) {
            result.addAll(this.generateTableAvailableSQLTokens((TableAvailable)sqlStatementContext));
        }
        if (sqlStatementContext instanceof IndexAvailable && !((IndexAvailable)sqlStatementContext).getIndexes().isEmpty()) {
            result.addAll(this.generateIndexAvailableSQLTokens((IndexAvailable)sqlStatementContext));
        }
        return result;
    }

    private Collection<RemoveToken> generateRemoveAvailableSQLTokens(Collection<SQLSegment> removeSegments) {
        return removeSegments.stream().map(each -> new RemoveToken(each.getStartIndex(), each.getStopIndex())).collect(Collectors.toList());
    }

    private Collection<RemoveToken> generateTableAvailableSQLTokens(TableAvailable tableAvailable) {
        LinkedList<RemoveToken> result = new LinkedList<RemoveToken>();
        for (SimpleTableSegment each : tableAvailable.getAllTables()) {
            if (!each.getOwner().isPresent()) continue;
            OwnerSegment owner = (OwnerSegment)each.getOwner().get();
            int startIndex = owner.getOwner().isPresent() ? ((OwnerSegment)owner.getOwner().get()).getStartIndex() : owner.getStartIndex();
            int stopIndex = owner.getOwner().isPresent() ? owner.getStartIndex() - 1 : each.getTableName().getStartIndex() - 1;
            result.add(new RemoveToken(startIndex, stopIndex));
        }
        return result;
    }

    private Collection<RemoveToken> generateIndexAvailableSQLTokens(IndexAvailable indexAvailable) {
        LinkedList<RemoveToken> result = new LinkedList<RemoveToken>();
        for (IndexSegment each : indexAvailable.getIndexes()) {
            if (!each.getOwner().isPresent()) continue;
            OwnerSegment owner = (OwnerSegment)each.getOwner().get();
            int startIndex = owner.getOwner().isPresent() ? ((OwnerSegment)owner.getOwner().get()).getStartIndex() : owner.getStartIndex();
            int stopIndex = owner.getOwner().isPresent() ? owner.getStartIndex() - 1 : each.getStartIndex() - 1;
            result.add(new RemoveToken(startIndex, stopIndex));
        }
        return result;
    }
}

