/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.impl;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.rewrite.sql.SQLBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.Substitutable;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.ComposableSQLToken;

public abstract class AbstractSQLBuilder
implements SQLBuilder {
    private final String sql;
    private final List<SQLToken> sqlTokens;

    @Override
    public final String toSQL() {
        if (this.sqlTokens.isEmpty()) {
            return this.sql;
        }
        Collections.sort(this.sqlTokens);
        StringBuilder result = new StringBuilder(this.sql.length());
        result.append(this.sql, 0, this.sqlTokens.get(0).getStartIndex());
        for (SQLToken each : this.sqlTokens) {
            if (each instanceof ComposableSQLToken) {
                result.append(this.getComposableSQLTokenText((ComposableSQLToken)each));
            } else {
                result.append(this.getSQLTokenText(each));
            }
            result.append(this.getConjunctionText(each));
        }
        return result.toString();
    }

    protected abstract String getSQLTokenText(SQLToken var1);

    private String getComposableSQLTokenText(ComposableSQLToken composableSQLToken) {
        StringBuilder result = new StringBuilder();
        for (SQLToken each : composableSQLToken.getSqlTokens()) {
            result.append(this.getSQLTokenText(each));
            result.append(this.getConjunctionText(each));
        }
        return result.toString();
    }

    private String getConjunctionText(SQLToken sqlToken) {
        return this.sql.substring(this.getStartIndex(sqlToken), this.getStopIndex(sqlToken));
    }

    private int getStartIndex(SQLToken sqlToken) {
        int startIndex = sqlToken instanceof Substitutable ? ((Substitutable)((Object)sqlToken)).getStopIndex() + 1 : sqlToken.getStartIndex();
        return Math.min(startIndex, this.sql.length());
    }

    private int getStopIndex(SQLToken sqlToken) {
        int currentSQLTokenIndex = this.sqlTokens.indexOf(sqlToken);
        return this.sqlTokens.size() - 1 == currentSQLTokenIndex ? this.sql.length() : this.sqlTokens.get(currentSQLTokenIndex + 1).getStartIndex();
    }

    @Generated
    public AbstractSQLBuilder(String sql, List<SQLToken> sqlTokens) {
        this.sql = sql;
        this.sqlTokens = sqlTokens;
    }
}

