/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.route.engine.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.route.engine.SQLRouteExecutor;
import org.apache.shardingsphere.infra.schema.ShardingSphereSchema;

public final class AllSQLRouteExecutor
implements SQLRouteExecutor {
    @Override
    public RouteContext route(LogicSQL logicSQL, ShardingSphereSchema schema) {
        RouteContext result = new RouteContext();
        for (String each : this.getAllDataSourceNames(schema)) {
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(each, each), Collections.emptyList()));
        }
        return result;
    }

    private Collection<String> getAllDataSourceNames(ShardingSphereSchema schema) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Collection each : schema.getMetaData().getTableAddressingMetaData().getTableDataSourceNamesMapper().values()) {
            result.addAll(each);
        }
        return result;
    }
}

