/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.route.hook;

import java.util.Collection;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.hook.RoutingHook;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;

public final class SPIRoutingHook
implements RoutingHook {
    private final Collection<RoutingHook> routingHooks = ShardingSphereServiceLoader.newServiceInstances(RoutingHook.class);

    @Override
    public void start(String sql) {
        for (RoutingHook each : this.routingHooks) {
            each.start(sql);
        }
    }

    @Override
    public void finishSuccess(RouteContext routeContext, PhysicalSchemaMetaData schemaMetaData) {
        for (RoutingHook each : this.routingHooks) {
            each.finishSuccess(routeContext, schemaMetaData);
        }
    }

    @Override
    public void finishFailure(Exception cause) {
        for (RoutingHook each : this.routingHooks) {
            each.finishFailure(cause);
        }
    }

    static {
        ShardingSphereServiceLoader.register(RoutingHook.class);
    }
}

