/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.session.connection;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.session.connection.cursor.CursorConnectionContext;
import org.apache.shardingsphere.infra.session.connection.datasource.UsedDataSourceProvider;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionConnectionContext;

public final class ConnectionContext
implements AutoCloseable {
    private final CursorConnectionContext cursorContext = new CursorConnectionContext();
    private final TransactionConnectionContext transactionContext = new TransactionConnectionContext();
    private final UsedDataSourceProvider usedDataSourceProvider;
    private String trafficInstanceId;

    public ConnectionContext() {
        this(Collections::emptySet);
    }

    public Collection<String> getUsedDataSourceNames() {
        return this.usedDataSourceProvider.getNames();
    }

    public Optional<String> getTrafficInstanceId() {
        return Optional.ofNullable(this.trafficInstanceId);
    }

    public void clearCursorConnectionContext() {
        this.cursorContext.close();
    }

    public void clearTransactionConnectionContext() {
        this.transactionContext.close();
    }

    @Override
    public void close() {
        this.trafficInstanceId = null;
        this.clearCursorConnectionContext();
        this.clearTransactionConnectionContext();
    }

    @Generated
    public ConnectionContext(UsedDataSourceProvider usedDataSourceProvider) {
        this.usedDataSourceProvider = usedDataSourceProvider;
    }

    @Generated
    public CursorConnectionContext getCursorContext() {
        return this.cursorContext;
    }

    @Generated
    public TransactionConnectionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Generated
    public void setTrafficInstanceId(String trafficInstanceId) {
        this.trafficInstanceId = trafficInstanceId;
    }
}

