/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.session.query;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.CommentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.AbstractSQLStatement;

public final class QueryContext {
    private final SQLStatementContext sqlStatementContext;
    private final String sql;
    private final List<Object> parameters;
    private final String databaseName;
    private final HintValueContext hintValueContext;
    private final boolean useCache;

    public QueryContext(SQLStatementContext sqlStatementContext, String sql, List<Object> params) {
        this(sqlStatementContext, sql, params, new HintValueContext());
    }

    public QueryContext(SQLStatementContext sqlStatementContext, String sql, List<Object> params, HintValueContext hintValueContext) {
        this(sqlStatementContext, sql, params, hintValueContext, false);
    }

    public QueryContext(SQLStatementContext sqlStatementContext, String sql, List<Object> params, HintValueContext hintValueContext, boolean useCache) {
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.parameters = params;
        this.databaseName = sqlStatementContext instanceof TableAvailable ? (String)((TableAvailable)sqlStatementContext).getTablesContext().getDatabaseName().orElse(null) : null;
        this.hintValueContext = sqlStatementContext.getSqlStatement() instanceof AbstractSQLStatement && !((AbstractSQLStatement)sqlStatementContext.getSqlStatement()).getCommentSegments().isEmpty() ? SQLHintUtils.extractHint((String)((CommentSegment)((AbstractSQLStatement)sqlStatementContext.getSqlStatement()).getCommentSegments().iterator().next()).getText()).orElse(hintValueContext) : hintValueContext;
        this.useCache = useCache;
    }

    public Optional<String> getDatabaseNameFromSQLStatement() {
        return Optional.ofNullable(this.databaseName);
    }

    @Generated
    public SQLStatementContext getSqlStatementContext() {
        return this.sqlStatementContext;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public HintValueContext getHintValueContext() {
        return this.hintValueContext;
    }

    @Generated
    public boolean isUseCache() {
        return this.useCache;
    }
}

