/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.spi.type.required;

import java.util.Collection;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.util.spi.exception.ServiceProviderNotFoundServerException;
import org.apache.shardingsphere.infra.util.spi.lifecycle.SPIPostProcessor;
import org.apache.shardingsphere.infra.util.spi.type.required.RequiredSPI;

public final class RequiredSPIRegistry {
    public static <T extends RequiredSPI> T getRegisteredService(Class<T> spiClass) {
        T result = RequiredSPIRegistry.getRequiredService(spiClass);
        if (result instanceof SPIPostProcessor) {
            ((SPIPostProcessor)result).init(new Properties());
        }
        return result;
    }

    private static <T extends RequiredSPI> T getRequiredService(Class<T> spiClass) {
        Collection<RequiredSPI> services = ShardingSphereServiceLoader.getServiceInstances(spiClass);
        if (services.isEmpty()) {
            throw new ServiceProviderNotFoundServerException(spiClass);
        }
        if (1 == services.size()) {
            return (T)services.iterator().next();
        }
        for (RequiredSPI each : services) {
            if (!each.isDefault()) continue;
            return (T)each;
        }
        return (T)services.iterator().next();
    }

    @Generated
    private RequiredSPIRegistry() {
    }
}

