/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.expr;

import groovy.lang.Closure;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.expr.EspressoInlineExpressionParser;
import org.apache.shardingsphere.infra.util.groovy.expr.HotspotInlineExpressionParser;

public final class InlineExpressionParser {
    private static final boolean IS_SUBSTRATE_VM = System.getProperty("java.vm.name").equals("Substrate VM");
    private final EspressoInlineExpressionParser espressoInlineExpressionParser;
    private final HotspotInlineExpressionParser hotspotInlineExpressionParser;

    public InlineExpressionParser(String inlineExpression) {
        if (IS_SUBSTRATE_VM) {
            this.hotspotInlineExpressionParser = null;
            this.espressoInlineExpressionParser = new EspressoInlineExpressionParser(inlineExpression);
        } else {
            this.hotspotInlineExpressionParser = new HotspotInlineExpressionParser(inlineExpression);
            this.espressoInlineExpressionParser = null;
        }
    }

    public static String handlePlaceHolder(String inlineExpression) {
        if (IS_SUBSTRATE_VM) {
            return EspressoInlineExpressionParser.handlePlaceHolder(inlineExpression);
        }
        return HotspotInlineExpressionParser.handlePlaceHolder((String)inlineExpression);
    }

    public List<String> splitAndEvaluate() {
        if (IS_SUBSTRATE_VM) {
            assert (null != this.espressoInlineExpressionParser);
            return this.espressoInlineExpressionParser.splitAndEvaluate();
        }
        assert (null != this.hotspotInlineExpressionParser);
        return this.hotspotInlineExpressionParser.splitAndEvaluate();
    }

    public Closure<?> evaluateClosure() {
        if (IS_SUBSTRATE_VM) {
            assert (null != this.espressoInlineExpressionParser);
            return this.espressoInlineExpressionParser.evaluateClosure();
        }
        assert (null != this.hotspotInlineExpressionParser);
        return this.hotspotInlineExpressionParser.evaluateClosure();
    }

    @Generated
    public InlineExpressionParser(EspressoInlineExpressionParser espressoInlineExpressionParser, HotspotInlineExpressionParser hotspotInlineExpressionParser) {
        this.espressoInlineExpressionParser = espressoInlineExpressionParser;
        this.hotspotInlineExpressionParser = hotspotInlineExpressionParser;
    }
}

