/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.governance.api.yaml;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.driver.governance.internal.datasource.GovernanceShardingSphereDataSource;
import org.apache.shardingsphere.driver.governance.internal.util.YamlGovernanceRepositoryConfigurationSwapperUtil;
import org.apache.shardingsphere.driver.governance.internal.yaml.YamlGovernanceRootRuleConfigurations;
import org.apache.shardingsphere.governance.core.yaml.config.YamlGovernanceConfiguration;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.infra.yaml.swapper.YamlRuleConfigurationSwapperEngine;

public final class YamlGovernanceShardingSphereDataSourceFactory {
    public static DataSource createDataSource(File yamlFile) throws SQLException, IOException {
        YamlGovernanceRootRuleConfigurations configurations = YamlGovernanceShardingSphereDataSourceFactory.unmarshal(yamlFile);
        return YamlGovernanceShardingSphereDataSourceFactory.createDataSource(configurations.getDataSources(), configurations, configurations.getProps(), configurations.getGovernance());
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, File yamlFile) throws SQLException, IOException {
        YamlGovernanceRootRuleConfigurations configurations = YamlGovernanceShardingSphereDataSourceFactory.unmarshal(yamlFile);
        return YamlGovernanceShardingSphereDataSourceFactory.createDataSource(dataSourceMap, configurations, configurations.getProps(), configurations.getGovernance());
    }

    public static DataSource createDataSource(byte[] yamlBytes) throws SQLException, IOException {
        YamlGovernanceRootRuleConfigurations configurations = YamlGovernanceShardingSphereDataSourceFactory.unmarshal(yamlBytes);
        return YamlGovernanceShardingSphereDataSourceFactory.createDataSource(configurations.getDataSources(), configurations, configurations.getProps(), configurations.getGovernance());
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, byte[] yamlBytes) throws SQLException, IOException {
        YamlGovernanceRootRuleConfigurations configurations = YamlGovernanceShardingSphereDataSourceFactory.unmarshal(yamlBytes);
        return YamlGovernanceShardingSphereDataSourceFactory.createDataSource(dataSourceMap, configurations, configurations.getProps(), configurations.getGovernance());
    }

    private static DataSource createDataSource(Map<String, DataSource> dataSourceMap, YamlGovernanceRootRuleConfigurations configurations, Properties props, YamlGovernanceConfiguration governance) throws SQLException {
        if (configurations.getRules().isEmpty() || dataSourceMap.isEmpty()) {
            return YamlGovernanceShardingSphereDataSourceFactory.createDataSourceWithoutRules(governance);
        }
        return YamlGovernanceShardingSphereDataSourceFactory.createDataSourceWithRules(dataSourceMap, new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations(configurations.getRules()), props, governance);
    }

    private static DataSource createDataSourceWithoutRules(YamlGovernanceConfiguration governance) throws SQLException {
        return new GovernanceShardingSphereDataSource(YamlGovernanceRepositoryConfigurationSwapperUtil.marshal(governance));
    }

    private static DataSource createDataSourceWithRules(Map<String, DataSource> dataSourceMap, Collection<RuleConfiguration> ruleConfigurations, Properties props, YamlGovernanceConfiguration governance) throws SQLException {
        return new GovernanceShardingSphereDataSource(dataSourceMap, ruleConfigurations, props, YamlGovernanceRepositoryConfigurationSwapperUtil.marshal(governance));
    }

    private static YamlGovernanceRootRuleConfigurations unmarshal(File yamlFile) throws IOException {
        return (YamlGovernanceRootRuleConfigurations)YamlEngine.unmarshal((File)yamlFile, YamlGovernanceRootRuleConfigurations.class);
    }

    private static YamlGovernanceRootRuleConfigurations unmarshal(byte[] yamlBytes) throws IOException {
        return (YamlGovernanceRootRuleConfigurations)YamlEngine.unmarshal((byte[])yamlBytes, YamlGovernanceRootRuleConfigurations.class);
    }

    @Generated
    private YamlGovernanceShardingSphereDataSourceFactory() {
    }
}

