/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.governance.internal.datasource;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.driver.governance.internal.circuit.datasource.CircuitBreakerDataSource;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.unsupported.AbstractUnsupportedOperationDataSource;
import org.apache.shardingsphere.governance.context.schema.GovernanceSchemaContexts;
import org.apache.shardingsphere.governance.core.config.ConfigCenter;
import org.apache.shardingsphere.governance.core.facade.GovernanceFacade;
import org.apache.shardingsphere.governance.repository.api.config.GovernanceConfiguration;
import org.apache.shardingsphere.infra.auth.Authentication;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConverter;
import org.apache.shardingsphere.infra.context.schema.SchemaContexts;
import org.apache.shardingsphere.infra.context.schema.SchemaContextsBuilder;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.transaction.ShardingTransactionManagerEngine;
import org.apache.shardingsphere.transaction.context.TransactionContexts;
import org.apache.shardingsphere.transaction.context.impl.StandardTransactionContexts;
import org.apache.shardingsphere.transaction.core.TransactionTypeHolder;

public final class GovernanceShardingSphereDataSource
extends AbstractUnsupportedOperationDataSource
implements AutoCloseable {
    private final SchemaContexts schemaContexts;
    private final TransactionContexts transactionContexts;

    public GovernanceShardingSphereDataSource(GovernanceConfiguration governanceConfig) throws SQLException {
        GovernanceFacade governanceFacade = this.createGovernanceFacade(governanceConfig);
        this.schemaContexts = new GovernanceSchemaContexts(this.createSchemaContexts(governanceFacade), governanceFacade);
        this.transactionContexts = this.createTransactionContexts(this.schemaContexts.getDatabaseType(), this.schemaContexts.getDefaultSchema().getDataSources());
    }

    public GovernanceShardingSphereDataSource(Map<String, DataSource> dataSourceMap, Collection<RuleConfiguration> ruleConfigs, Properties props, GovernanceConfiguration governanceConfig) throws SQLException {
        GovernanceFacade governanceFacade = this.createGovernanceFacade(governanceConfig);
        this.schemaContexts = new GovernanceSchemaContexts(this.createSchemaContexts(dataSourceMap, ruleConfigs, props), governanceFacade);
        this.transactionContexts = this.createTransactionContexts(this.schemaContexts.getDatabaseType(), this.schemaContexts.getDefaultSchema().getDataSources());
        this.uploadLocalConfiguration(governanceFacade);
    }

    private GovernanceFacade createGovernanceFacade(GovernanceConfiguration config) {
        GovernanceFacade result = new GovernanceFacade();
        result.init(config, Collections.singletonList("logic_db"));
        result.onlineInstance();
        return result;
    }

    private SchemaContexts createSchemaContexts(GovernanceFacade governanceFacade) throws SQLException {
        ConfigCenter configCenter = governanceFacade.getConfigCenter();
        Map dataSourceConfigs = configCenter.loadDataSourceConfigurations("logic_db");
        Collection ruleConfigurations = configCenter.loadRuleConfigurations("logic_db");
        Map dataSourceMap = DataSourceConverter.getDataSourceMap((Map)dataSourceConfigs);
        SchemaContextsBuilder schemaContextsBuilder = new SchemaContextsBuilder(this.createDatabaseType(dataSourceMap), Collections.singletonMap("logic_db", dataSourceMap), Collections.singletonMap("logic_db", ruleConfigurations), new Authentication(), configCenter.loadProperties());
        return schemaContextsBuilder.build();
    }

    private SchemaContexts createSchemaContexts(Map<String, DataSource> dataSourceMap, Collection<RuleConfiguration> ruleConfigs, Properties props) throws SQLException {
        SchemaContextsBuilder schemaContextsBuilder = new SchemaContextsBuilder(this.createDatabaseType(dataSourceMap), Collections.singletonMap("logic_db", dataSourceMap), Collections.singletonMap("logic_db", ruleConfigs), new Authentication(), props);
        return schemaContextsBuilder.build();
    }

    private DatabaseType createDatabaseType(Map<String, DataSource> dataSourceMap) throws SQLException {
        DatabaseType result = null;
        for (DataSource each : dataSourceMap.values()) {
            DatabaseType databaseType = this.createDatabaseType(each);
            Preconditions.checkState((null == result || result == databaseType ? 1 : 0) != 0, (Object)String.format("Database type inconsistent with '%s' and '%s'", result, databaseType));
            result = databaseType;
        }
        return result;
    }

    private DatabaseType createDatabaseType(DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            DatabaseType databaseType = DatabaseTypeRegistry.getDatabaseTypeByURL((String)connection.getMetaData().getURL());
            return databaseType;
        }
    }

    private TransactionContexts createTransactionContexts(DatabaseType databaseType, Map<String, DataSource> dataSourceMap) {
        ShardingTransactionManagerEngine engine = new ShardingTransactionManagerEngine();
        engine.init(databaseType, dataSourceMap);
        return new StandardTransactionContexts(Collections.singletonMap("logic_db", engine));
    }

    private void uploadLocalConfiguration(GovernanceFacade governanceFacade) {
        Map dataSourceConfigs = DataSourceConverter.getDataSourceConfigurationMap((Map)this.schemaContexts.getDefaultSchema().getDataSources());
        Collection ruleConfigurations = this.schemaContexts.getDefaultSchema().getConfigurations();
        governanceFacade.onlineInstance(Collections.singletonMap("logic_db", dataSourceConfigs), Collections.singletonMap("logic_db", ruleConfigurations), null, this.schemaContexts.getProps().getProps());
    }

    public Connection getConnection() {
        return this.schemaContexts.isCircuitBreak() ? new CircuitBreakerDataSource().getConnection() : new ShardingSphereConnection(this.getDataSourceMap(), this.schemaContexts, this.transactionContexts, TransactionTypeHolder.get());
    }

    public Connection getConnection(String username, String password) {
        return this.getConnection();
    }

    @Override
    public void close() throws Exception {
        this.getDataSourceMap().forEach((key, value) -> this.close((DataSource)value));
        this.schemaContexts.close();
    }

    private void close(DataSource dataSource) {
        try {
            Method method = dataSource.getClass().getDeclaredMethod("close", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)dataSource, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    private Map<String, DataSource> getDataSourceMap() {
        return this.schemaContexts.getDefaultSchema().getDataSources();
    }

    @Generated
    public SchemaContexts getSchemaContexts() {
        return this.schemaContexts;
    }

    @Generated
    public TransactionContexts getTransactionContexts() {
        return this.transactionContexts;
    }
}

