/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.merge;

import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.spi.database.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.underlying.common.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.underlying.common.rule.BaseRule;
import org.apache.shardingsphere.underlying.executor.QueryResult;
import org.apache.shardingsphere.underlying.merge.engine.ResultProcessEngine;
import org.apache.shardingsphere.underlying.merge.engine.decorator.ResultDecorator;
import org.apache.shardingsphere.underlying.merge.engine.decorator.ResultDecoratorEngine;
import org.apache.shardingsphere.underlying.merge.engine.merger.ResultMerger;
import org.apache.shardingsphere.underlying.merge.engine.merger.ResultMergerEngine;
import org.apache.shardingsphere.underlying.merge.result.MergedResult;
import org.apache.shardingsphere.underlying.merge.result.impl.transparent.TransparentMergedResult;

public final class MergeEntry {
    private final DatabaseType databaseType;
    private final SchemaMetaData schemaMetaData;
    private final ConfigurationProperties properties;
    private final Map<BaseRule, ResultProcessEngine> engines = new LinkedHashMap<BaseRule, ResultProcessEngine>();

    public void registerProcessEngine(BaseRule rule, ResultProcessEngine processEngine) {
        this.engines.put(rule, processEngine);
    }

    public MergedResult process(List<QueryResult> queryResults, SQLStatementContext sqlStatementContext) throws SQLException {
        Optional<MergedResult> mergedResult = this.merge(queryResults, sqlStatementContext);
        Optional<MergedResult> result = mergedResult.isPresent() ? Optional.of(this.decorate(mergedResult.get(), sqlStatementContext)) : this.decorate(queryResults.get(0), sqlStatementContext);
        return result.orElseGet(() -> new TransparentMergedResult((QueryResult)queryResults.get(0)));
    }

    private Optional<MergedResult> merge(List<QueryResult> queryResults, SQLStatementContext sqlStatementContext) throws SQLException {
        for (Map.Entry<BaseRule, ResultProcessEngine> entry : this.engines.entrySet()) {
            if (!(entry.getValue() instanceof ResultMergerEngine)) continue;
            ResultMerger resultMerger = ((ResultMergerEngine)entry.getValue()).newInstance(this.databaseType, entry.getKey(), this.properties, sqlStatementContext);
            return Optional.of(resultMerger.merge(queryResults, sqlStatementContext, this.schemaMetaData));
        }
        return Optional.empty();
    }

    private MergedResult decorate(MergedResult mergedResult, SQLStatementContext sqlStatementContext) throws SQLException {
        MergedResult result = null;
        for (Map.Entry<BaseRule, ResultProcessEngine> entry : this.engines.entrySet()) {
            if (!(entry.getValue() instanceof ResultDecoratorEngine)) continue;
            ResultDecorator resultDecorator = ((ResultDecoratorEngine)entry.getValue()).newInstance(this.databaseType, this.schemaMetaData, entry.getKey(), this.properties, sqlStatementContext);
            result = null == result ? resultDecorator.decorate(mergedResult, sqlStatementContext, this.schemaMetaData) : resultDecorator.decorate(result, sqlStatementContext, this.schemaMetaData);
        }
        return null == result ? mergedResult : result;
    }

    private Optional<MergedResult> decorate(QueryResult queryResult, SQLStatementContext sqlStatementContext) throws SQLException {
        MergedResult result = null;
        for (Map.Entry<BaseRule, ResultProcessEngine> entry : this.engines.entrySet()) {
            if (!(entry.getValue() instanceof ResultDecoratorEngine)) continue;
            ResultDecorator resultDecorator = ((ResultDecoratorEngine)entry.getValue()).newInstance(this.databaseType, this.schemaMetaData, entry.getKey(), this.properties, sqlStatementContext);
            result = null == result ? resultDecorator.decorate(queryResult, sqlStatementContext, this.schemaMetaData) : resultDecorator.decorate(result, sqlStatementContext, this.schemaMetaData);
        }
        return Optional.ofNullable(result);
    }

    @Generated
    public MergeEntry(DatabaseType databaseType, SchemaMetaData schemaMetaData, ConfigurationProperties properties) {
        this.databaseType = databaseType;
        this.schemaMetaData = schemaMetaData;
        this.properties = properties;
    }
}

