/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.path.rule.item;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.mode.path.rule.root.RuleRootNodePath;

public final class NamedRuleItemNodePath {
    private static final String NAME = "/([\\w\\-]+)/versions/\\d+$";
    private static final String ACTIVE_VERSION = "/([\\w\\-]+)/active_version$";
    private final String type;
    private final Pattern namePathPattern;
    private final Pattern activeVersionPathPattern;
    private final Pattern itemPathPattern;

    public NamedRuleItemNodePath(RuleRootNodePath rootNodePath, String type) {
        this.type = type;
        this.namePathPattern = Pattern.compile(rootNodePath.getNodePrefix() + type + NAME);
        this.activeVersionPathPattern = Pattern.compile(rootNodePath.getNodePrefix() + type + ACTIVE_VERSION);
        this.itemPathPattern = Pattern.compile(rootNodePath.getNodePrefix() + type + "/([\\w\\-]+)$");
    }

    public String getPath(String itemName) {
        return String.join((CharSequence)"/", this.type, itemName);
    }

    public Optional<String> getName(String path) {
        Matcher matcher = this.namePathPattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public Optional<String> getNameByActiveVersion(String path) {
        Matcher matcher = this.activeVersionPathPattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public Optional<String> getNameByItemPath(String path) {
        Matcher matcher = this.itemPathPattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }
}

