/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.opengauss.packet.command.generic;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierTag;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLMessagePacketType;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;
import org.opengauss.util.ServerErrorMessage;

public final class OpenGaussErrorResponsePacket
extends PostgreSQLIdentifierPacket {
    public static final char FIELD_TYPE_SEVERITY = 'S';
    public static final char FIELD_TYPE_CODE = 'C';
    public static final char FIELD_TYPE_MESSAGE = 'M';
    public static final char FIELD_TYPE_DETAIL = 'D';
    public static final char FIELD_TYPE_HINT = 'H';
    public static final char FIELD_TYPE_POSITION = 'P';
    public static final char FIELD_TYPE_INTERNAL_POSITION = 'p';
    public static final char FIELD_TYPE_INTERNAL_QUERY = 'q';
    public static final char FIELD_TYPE_WHERE = 'W';
    public static final char FIELD_TYPE_FILE = 'F';
    public static final char FIELD_TYPE_LINE = 'L';
    public static final char FIELD_TYPE_ROUTINE = 'R';
    public static final char FIELD_TYPE_ERRORCODE = 'c';
    private final Map<Character, String> fields;

    public OpenGaussErrorResponsePacket(ServerErrorMessage serverErrorMessage) {
        this.fields = new LinkedHashMap<Character, String>(13, 1.0f);
        this.fillFieldsByServerErrorMessage(serverErrorMessage);
        this.fillRequiredFieldsIfNecessary();
    }

    public OpenGaussErrorResponsePacket(String severityLevel, String sqlState, String message) {
        this.fields = new LinkedHashMap<Character, String>(4, 1.0f);
        this.fields.put(Character.valueOf('S'), severityLevel);
        this.fields.put(Character.valueOf('C'), sqlState);
        this.fields.put(Character.valueOf('M'), message);
        this.fillRequiredFieldsIfNecessary();
    }

    private void fillFieldsByServerErrorMessage(ServerErrorMessage serverErrorMessage) {
        if (null != serverErrorMessage.getSeverity()) {
            this.fields.put(Character.valueOf('S'), serverErrorMessage.getSeverity());
        }
        if (null != serverErrorMessage.getSQLState()) {
            this.fields.put(Character.valueOf('C'), serverErrorMessage.getSQLState());
        }
        if (null != serverErrorMessage.getMessage()) {
            this.fields.put(Character.valueOf('M'), serverErrorMessage.getMessage());
        }
        if (null != serverErrorMessage.getERRORCODE()) {
            this.fields.put(Character.valueOf('c'), serverErrorMessage.getERRORCODE());
        }
        if (null != serverErrorMessage.getDetail()) {
            this.fields.put(Character.valueOf('D'), serverErrorMessage.getDetail());
        }
        if (null != serverErrorMessage.getHint()) {
            this.fields.put(Character.valueOf('H'), serverErrorMessage.getHint());
        }
        if (serverErrorMessage.getPosition() > 0) {
            this.fields.put(Character.valueOf('P'), String.valueOf(serverErrorMessage.getPosition()));
        }
        if (serverErrorMessage.getInternalPosition() > 0) {
            this.fields.put(Character.valueOf('p'), String.valueOf(serverErrorMessage.getInternalPosition()));
        }
        if (null != serverErrorMessage.getInternalQuery()) {
            this.fields.put(Character.valueOf('q'), serverErrorMessage.getInternalQuery());
        }
        if (null != serverErrorMessage.getWhere()) {
            this.fields.put(Character.valueOf('W'), serverErrorMessage.getWhere());
        }
        if (null != serverErrorMessage.getFile()) {
            this.fields.put(Character.valueOf('F'), serverErrorMessage.getFile());
        }
        if (serverErrorMessage.getLine() > 0) {
            this.fields.put(Character.valueOf('L'), String.valueOf(serverErrorMessage.getLine()));
        }
        if (null != serverErrorMessage.getRoutine()) {
            this.fields.put(Character.valueOf('R'), serverErrorMessage.getRoutine());
        }
    }

    private void fillRequiredFieldsIfNecessary() {
        this.fields.putIfAbsent(Character.valueOf('c'), "0");
    }

    protected void write(PostgreSQLPacketPayload payload) {
        for (Map.Entry<Character, String> entry : this.fields.entrySet()) {
            payload.writeInt1((int)entry.getKey().charValue());
            payload.writeStringNul(entry.getValue());
        }
        payload.writeInt1(0);
    }

    public PostgreSQLIdentifierTag getIdentifier() {
        return PostgreSQLMessagePacketType.ERROR_RESPONSE;
    }
}

