/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.sysvar.MySQLSystemVariable;
import org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.sysvar.Scope;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.VariableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class MySQLSystemVariableQueryExecutor
implements DatabaseAdminQueryExecutor {
    private final List<ExpressionProjectionSegment> projections;
    private final List<MySQLSystemVariable> variables;
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;

    public void execute(ConnectionSession connectionSession) {
        ArrayList<RawQueryResultColumnMetaData> metaData = new ArrayList<RawQueryResultColumnMetaData>(this.projections.size());
        ArrayList<String> columnsOfRow = new ArrayList<String>(this.projections.size());
        for (int i = 0; i < this.projections.size(); ++i) {
            ExpressionProjectionSegment projection = this.projections.get(i);
            VariableSegment variableSegment = (VariableSegment)projection.getExpr();
            Scope scope = variableSegment.getScope().map(Scope::getScope).orElse(Scope.DEFAULT);
            columnsOfRow.add(this.variables.get(i).getValue(scope, connectionSession));
            String name = projection.getAliasName().orElseGet(() -> "@@" + variableSegment.getScope().map(s -> s + ".").orElse("") + variableSegment.getVariable());
            metaData.add(new RawQueryResultColumnMetaData("", name, name, 12, "VARCHAR", 1024, 0));
        }
        this.queryResultMetaData = new RawQueryResultMetaData(metaData);
        this.mergedResult = new LocalDataMergedResult(Collections.singleton(new LocalDataQueryResultRow(columnsOfRow.toArray())));
    }

    public static Optional<DatabaseAdminExecutor> tryGetSystemVariableQueryExecutor(SelectStatement selectStatement) {
        Collection projections = selectStatement.getProjections().getProjections();
        ArrayList<ExpressionProjectionSegment> expressionProjectionSegments = new ArrayList<ExpressionProjectionSegment>(projections.size());
        ArrayList<MySQLSystemVariable> variables = new ArrayList<MySQLSystemVariable>(projections.size());
        for (ProjectionSegment each : projections) {
            if (!(each instanceof ExpressionProjectionSegment)) {
                return Optional.empty();
            }
            ExpressionProjectionSegment expression = (ExpressionProjectionSegment)each;
            if (!(expression.getExpr() instanceof VariableSegment)) {
                return Optional.empty();
            }
            expressionProjectionSegments.add(expression);
            VariableSegment variable = (VariableSegment)expression.getExpr();
            Optional<MySQLSystemVariable> systemVariable = MySQLSystemVariable.findSystemVariable(variable.getVariable());
            if (!systemVariable.isPresent()) {
                return Optional.empty();
            }
            variables.add(systemVariable.get());
        }
        return Optional.of(new MySQLSystemVariableQueryExecutor(expressionProjectionSegments, variables));
    }

    @Generated
    private MySQLSystemVariableQueryExecutor(List<ExpressionProjectionSegment> projections, List<MySQLSystemVariable> variables) {
        this.projections = projections;
        this.variables = variables;
    }

    @Generated
    public QueryResultMetaData getQueryResultMetaData() {
        return this.queryResultMetaData;
    }

    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

