/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.infra.executor.sql.process.Process;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.mode.process.event.ShowProcessListRequestEvent;
import org.apache.shardingsphere.mode.process.event.ShowProcessListResponseEvent;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class ShowProcessListExecutor
implements DatabaseAdminQueryExecutor {
    private final boolean showFullProcesslist;
    private Collection<Process> processes;
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;

    public ShowProcessListExecutor(boolean showFullProcesslist) {
        this.showFullProcesslist = showFullProcesslist;
        ProxyContext.getInstance().getContextManager().getInstanceContext().getEventBusContext().register((Object)this);
    }

    @Subscribe
    public void receiveProcessListData(ShowProcessListResponseEvent event) {
        this.processes = event.getProcesses();
    }

    public void execute(ConnectionSession connectionSession) {
        this.queryResultMetaData = this.createQueryResultMetaData();
        this.mergedResult = new TransparentMergedResult(this.getQueryResult());
    }

    private QueryResult getQueryResult() {
        ProxyContext.getInstance().getContextManager().getInstanceContext().getEventBusContext().post((Object)new ShowProcessListRequestEvent());
        if (null == this.processes || this.processes.isEmpty()) {
            return new RawMemoryQueryResult(this.queryResultMetaData, Collections.emptyList());
        }
        List rows = this.processes.stream().map(this::getMemoryQueryResultDataRow).collect(Collectors.toList());
        return new RawMemoryQueryResult(this.queryResultMetaData, rows);
    }

    private MemoryQueryResultDataRow getMemoryQueryResultDataRow(Process process) {
        ArrayList<Object> rowValues = new ArrayList<Object>(8);
        rowValues.add(process.getId());
        rowValues.add(process.getUsername());
        rowValues.add(process.getHostname());
        rowValues.add(process.getDatabaseName());
        rowValues.add(process.isIdle() ? "Sleep" : "Execute");
        rowValues.add(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - process.getStartMillis()));
        String sql = null;
        if (process.isIdle()) {
            rowValues.add("");
        } else {
            int processDoneCount = process.getCompletedUnitCount();
            String statePrefix = "Executing ";
            rowValues.add(statePrefix + processDoneCount + "/" + process.getTotalUnitCount());
            sql = process.getSql();
        }
        if (null != sql && sql.length() > 100 && !this.showFullProcesslist) {
            sql = sql.substring(0, 100);
        }
        rowValues.add(null != sql ? sql : "");
        return new MemoryQueryResultDataRow(rowValues);
    }

    private QueryResultMetaData createQueryResultMetaData() {
        ArrayList<RawQueryResultColumnMetaData> columns = new ArrayList<RawQueryResultColumnMetaData>(8);
        columns.add(new RawQueryResultColumnMetaData("", "Id", "Id", 12, "VARCHAR", 20, 0));
        columns.add(new RawQueryResultColumnMetaData("", "User", "User", 12, "VARCHAR", 20, 0));
        columns.add(new RawQueryResultColumnMetaData("", "Host", "Host", 12, "VARCHAR", 64, 0));
        columns.add(new RawQueryResultColumnMetaData("", "db", "db", 12, "VARCHAR", 64, 0));
        columns.add(new RawQueryResultColumnMetaData("", "Command", "Command", 12, "VARCHAR", 64, 0));
        columns.add(new RawQueryResultColumnMetaData("", "Time", "Time", 12, "VARCHAR", 10, 0));
        columns.add(new RawQueryResultColumnMetaData("", "State", "State", 12, "VARCHAR", 64, 0));
        columns.add(new RawQueryResultColumnMetaData("", "Info", "Info", 12, "VARCHAR", 120, 0));
        return new RawQueryResultMetaData(columns);
    }

    @Generated
    public QueryResultMetaData getQueryResultMetaData() {
        return this.queryResultMetaData;
    }

    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

