/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor;

import lombok.Generated;
import org.apache.shardingsphere.authority.checker.AuthorityChecker;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.UseStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtils;

public final class UseDatabaseExecutor
implements DatabaseAdminExecutor {
    private final UseStatement useStatement;

    public void execute(ConnectionSession connectionSession) {
        String databaseName = SQLUtils.getExactlyValue((String)this.useStatement.getSchema());
        AuthorityRule authorityRule = (AuthorityRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(AuthorityRule.class);
        AuthorityChecker authorityChecker = new AuthorityChecker(authorityRule, connectionSession.getGrantee());
        ShardingSpherePreconditions.checkState((ProxyContext.getInstance().databaseExists(databaseName) && authorityChecker.isAuthorized(databaseName) ? 1 : 0) != 0, () -> new UnknownDatabaseException(databaseName));
        connectionSession.setCurrentDatabase(databaseName);
    }

    @Generated
    public UseDatabaseExecutor(UseStatement useStatement) {
        this.useStatement = useStatement;
    }
}

