/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.information;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.AbstractDatabaseMetaDataExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class SelectInformationSchemataExecutor
extends AbstractDatabaseMetaDataExecutor.DefaultDatabaseMetaDataExecutor {
    public static final String SCHEMA_NAME = "SCHEMA_NAME";
    public static final String DEFAULT_CHARACTER_SET_NAME = "DEFAULT_CHARACTER_SET_NAME";
    public static final String DEFAULT_COLLATION_NAME = "DEFAULT_COLLATION_NAME";
    public static final String CATALOG_NAME = "CATALOG_NAME";
    public static final String SQL_PATH = "SQL_PATH";
    public static final String DEFAULT_ENCRYPTION = "DEFAULT_ENCRYPTION";
    private static final Collection<String> SCHEMA_WITHOUT_DATA_SOURCE = new LinkedHashSet<String>();
    private final SelectStatement sqlStatement;
    private String schemaNameAlias = "SCHEMA_NAME";
    private boolean queryDatabase;

    public SelectInformationSchemataExecutor(SelectStatement sqlStatement, String sql, List<Object> parameters) {
        super(sql, parameters);
        this.sqlStatement = sqlStatement;
    }

    protected void postProcess() {
        this.removeDuplicatedRow();
    }

    private void removeDuplicatedRow() {
        if (this.queryDatabase) {
            Collection reservedRow = this.getRows().stream().collect(Collectors.groupingBy(each -> Optional.ofNullable(each.get(this.schemaNameAlias)), Collectors.toCollection(LinkedList::new))).values().stream().map(LinkedList::getFirst).collect(Collectors.toList());
            reservedRow.forEach(each -> this.getRows().removeIf(row -> !this.getRows().contains(each)));
        }
    }

    protected Collection<String> getDatabaseNames(ConnectionSession connectionSession) {
        Collection databaseNames = ProxyContext.getInstance().getAllDatabaseNames().stream().filter(each -> SelectInformationSchemataExecutor.isAuthorized((String)each, (Grantee)connectionSession.getGrantee())).collect(Collectors.toList());
        SCHEMA_WITHOUT_DATA_SOURCE.addAll(databaseNames.stream().filter(each -> AbstractDatabaseMetaDataExecutor.hasDataSource((String)each) == false).collect(Collectors.toSet()));
        Collection result = databaseNames.stream().filter(AbstractDatabaseMetaDataExecutor::hasDataSource).collect(Collectors.toList());
        if (!SCHEMA_WITHOUT_DATA_SOURCE.isEmpty()) {
            this.fillSchemasWithoutDataSource();
        }
        return result;
    }

    protected void preProcess(String databaseName, Map<String, Object> rows, Map<String, String> alias) {
        ResourceMetaData resourceMetaData = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabase(databaseName).getResourceMetaData();
        Collection catalogs = resourceMetaData.getStorageUnits().keySet().stream().map(each -> ((StorageUnit)resourceMetaData.getStorageUnits().get(each)).getCatalog()).collect(Collectors.toSet());
        this.schemaNameAlias = alias.getOrDefault(SCHEMA_NAME, "");
        String rowValue = rows.getOrDefault(this.schemaNameAlias, "").toString();
        boolean bl = this.queryDatabase = !rowValue.isEmpty();
        if (catalogs.contains(rowValue)) {
            rows.replace(this.schemaNameAlias, databaseName);
        } else {
            rows.clear();
        }
    }

    private void fillSchemasWithoutDataSource() {
        if (SCHEMA_WITHOUT_DATA_SOURCE.isEmpty()) {
            return;
        }
        Map<String, String> defaultRowData = this.getTheDefaultRowData();
        SCHEMA_WITHOUT_DATA_SOURCE.forEach(each -> {
            LinkedHashMap<String, String> row = new LinkedHashMap<String, String>(defaultRowData);
            row.replace(SCHEMA_NAME, (String)each);
            this.getRows().add(row);
        });
        SCHEMA_WITHOUT_DATA_SOURCE.clear();
    }

    private Map<String, String> getTheDefaultRowData() {
        Collection projections = this.sqlStatement.getProjections().getProjections();
        Map<String, String> result = projections.stream().anyMatch(ShorthandProjectionSegment.class::isInstance) ? Stream.of(CATALOG_NAME, SCHEMA_NAME, DEFAULT_CHARACTER_SET_NAME, DEFAULT_COLLATION_NAME, SQL_PATH, DEFAULT_ENCRYPTION).collect(Collectors.toMap(each -> each, each -> "")) : projections.stream().map(each -> ((ColumnProjectionSegment)each).getColumn().getIdentifier()).map(each -> each.getValue().toUpperCase()).collect(Collectors.toMap(each -> each, each -> ""));
        return result;
    }
}

