/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.postgresql.handler.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.metadata.database.schema.manager.SystemSchemaManager;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.AbstractDatabaseMetaDataExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutorCreator;
import org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.executor.PostgreSQLResetVariableAdminExecutor;
import org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.executor.PostgreSQLSetVariableAdminExecutor;
import org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.executor.PostgreSQLShowVariableExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.ResetParameterStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.ShowStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class PostgreSQLAdminExecutorCreator
implements DatabaseAdminExecutorCreator {
    private static final String PG_CLASS = "pg_class";
    private static final String PG_NAMESPACE = "pg_namespace";
    private static final Collection<String> KERNEL_SUPPORTED_TABLES = Arrays.asList("pg_namespace", "pg_class");

    public Optional<DatabaseAdminExecutor> create(SQLStatementContext sqlStatementContext) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof ShowStatement) {
            return Optional.of(new PostgreSQLShowVariableExecutor((ShowStatement)sqlStatement));
        }
        return Optional.empty();
    }

    public Optional<DatabaseAdminExecutor> create(SQLStatementContext sqlStatementContext, String sql, String databaseName, List<Object> parameters) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof SelectStatement) {
            Collection<String> selectedTableNames = this.getSelectedTableNames((SelectStatement)sqlStatement);
            if (!selectedTableNames.isEmpty() && KERNEL_SUPPORTED_TABLES.containsAll(selectedTableNames)) {
                return Optional.empty();
            }
            if (!selectedTableNames.isEmpty() && (SystemSchemaManager.isSystemTable((String)"postgresql", (String)"information_schema", selectedTableNames) || SystemSchemaManager.isSystemTable((String)"postgresql", (String)"pg_catalog", selectedTableNames))) {
                return Optional.of(new AbstractDatabaseMetaDataExecutor.DefaultDatabaseMetaDataExecutor(sql, parameters));
            }
        }
        if (sqlStatement instanceof SetStatement) {
            return Optional.of(new PostgreSQLSetVariableAdminExecutor((SetStatement)sqlStatement));
        }
        if (sqlStatement instanceof ResetParameterStatement) {
            return Optional.of(new PostgreSQLResetVariableAdminExecutor((ResetParameterStatement)sqlStatement));
        }
        return Optional.empty();
    }

    private Collection<String> getSelectedTableNames(SelectStatement sqlStatement) {
        TableExtractor extractor = new TableExtractor();
        extractor.extractTablesFromSelect(sqlStatement);
        LinkedList extracted = new LinkedList(extractor.getTableContext());
        for (TableSegment each : extractor.getTableContext()) {
            if (!(each instanceof SubqueryTableSegment)) continue;
            TableExtractor subExtractor = new TableExtractor();
            subExtractor.extractTablesFromSelect(((SubqueryTableSegment)each).getSubquery().getSelect());
            extracted.addAll(subExtractor.getTableContext());
        }
        ArrayList<String> result = new ArrayList<String>(extracted.size());
        for (TableSegment each : extracted) {
            if (!(each instanceof SimpleTableSegment)) continue;
            result.add(((SimpleTableSegment)each).getTableName().getIdentifier().getValue());
        }
        return result;
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }
}

