/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.config;

import ch.qos.logback.classic.BasicConfigurator;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;

public class LogbackConfiguration
extends BasicConfigurator {
    public static final String DEFAULT_PATTERN = "[%-5level] %d{yyyy-MM-dd HH:mm:ss.SSS} [%thread] %logger{36} - %msg%n";
    public static final String SHARDINGSPHERE_SQL_LOGGER_NAME = "ShardingSphere-SQL";
    public static final String HIKARI_LOGGER_NAME = "com.zaxxer.hikari";
    public static final String ATOMIKOS_LOGGER_NAME = "com.atomikos";
    public static final String NETTY_LOGGER_NAME = "io.netty";

    public void configure(LoggerContext loggerContext) {
        ConsoleAppender<ILoggingEvent> consoleAppender = this.createConsoleAppender(loggerContext);
        Logger rootLogger = loggerContext.getLogger("ROOT");
        rootLogger.setLevel(Level.INFO);
        rootLogger.addAppender(consoleAppender);
        this.initBasicLogger(loggerContext);
    }

    private ConsoleAppender<ILoggingEvent> createConsoleAppender(LoggerContext loggerContext) {
        ConsoleAppender result = new ConsoleAppender();
        result.setContext((Context)loggerContext);
        result.setName("console");
        LayoutWrappingEncoder<ILoggingEvent> encoder = this.createEncoder(loggerContext);
        result.setEncoder(encoder);
        result.start();
        return result;
    }

    private LayoutWrappingEncoder<ILoggingEvent> createEncoder(LoggerContext loggerContext) {
        LayoutWrappingEncoder result = new LayoutWrappingEncoder();
        result.setContext((Context)loggerContext);
        PatternLayout layout = this.createConsolePatternLayout(loggerContext);
        result.setLayout((Layout)layout);
        return result;
    }

    private PatternLayout createConsolePatternLayout(LoggerContext loggerContext) {
        PatternLayout result = new PatternLayout();
        result.setPattern(DEFAULT_PATTERN);
        result.setContext((Context)loggerContext);
        result.start();
        return result;
    }

    private void initBasicLogger(LoggerContext loggerContext) {
        loggerContext.getLogger(SHARDINGSPHERE_SQL_LOGGER_NAME).setLevel(Level.INFO);
        loggerContext.getLogger(HIKARI_LOGGER_NAME).setLevel(Level.ERROR);
        loggerContext.getLogger(ATOMIKOS_LOGGER_NAME).setLevel(Level.ERROR);
        loggerContext.getLogger(NETTY_LOGGER_NAME).setLevel(Level.ERROR);
    }
}

