/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.converter;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.segment.ReadwriteSplittingRuleSegment;

public final class ReadwriteSplittingRuleStatementConverter {
    public static ReadwriteSplittingRuleConfiguration convert(Collection<ReadwriteSplittingRuleSegment> ruleSegments) {
        LinkedList<ReadwriteSplittingDataSourceRuleConfiguration> dataSources = new LinkedList<ReadwriteSplittingDataSourceRuleConfiguration>();
        HashMap<String, ShardingSphereAlgorithmConfiguration> loadBalancers = new HashMap<String, ShardingSphereAlgorithmConfiguration>(ruleSegments.size(), 1.0f);
        for (ReadwriteSplittingRuleSegment each : ruleSegments) {
            String loadBalancerName = ReadwriteSplittingRuleStatementConverter.getLoadBalancerName(each.getName(), each.getLoadBalancer());
            dataSources.add(ReadwriteSplittingRuleStatementConverter.createDataSourceRuleConfiguration(each.getName(), loadBalancerName, each));
            loadBalancers.put(loadBalancerName, ReadwriteSplittingRuleStatementConverter.createLoadBalancer(each));
        }
        return new ReadwriteSplittingRuleConfiguration(dataSources, loadBalancers);
    }

    private static ReadwriteSplittingDataSourceRuleConfiguration createDataSourceRuleConfiguration(String name, String loadBalancerName, ReadwriteSplittingRuleSegment ruleSegment) {
        return Strings.isNullOrEmpty((String)ruleSegment.getAutoAwareResource()) ? new ReadwriteSplittingDataSourceRuleConfiguration(name, null, ruleSegment.getWriteDataSource(), new LinkedList(ruleSegment.getReadDataSources()), loadBalancerName) : new ReadwriteSplittingDataSourceRuleConfiguration(name, ruleSegment.getAutoAwareResource(), null, Collections.emptyList(), loadBalancerName);
    }

    private static ShardingSphereAlgorithmConfiguration createLoadBalancer(ReadwriteSplittingRuleSegment ruleSegment) {
        return new ShardingSphereAlgorithmConfiguration(ruleSegment.getLoadBalancer(), ruleSegment.getProps());
    }

    private static String getLoadBalancerName(String ruleName, String type) {
        return String.format("%s_%s", ruleName, type);
    }

    @Generated
    private ReadwriteSplittingRuleStatementConverter() {
    }
}

