/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.checker;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.distsql.handler.exception.rule.InvalidRuleConfigurationException;
import org.apache.shardingsphere.distsql.handler.exception.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.distsql.handler.exception.storageunit.MissingRequiredStorageUnitsException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.transaction.TransactionalReadQueryStrategy;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.segment.ReadwriteSplittingRuleSegment;
import org.apache.shardingsphere.readwritesplitting.spi.ReadQueryLoadBalanceAlgorithm;

public final class ReadwriteSplittingRuleStatementChecker {
    public static void checkCreation(ShardingSphereDatabase database, Collection<ReadwriteSplittingRuleSegment> segments, ReadwriteSplittingRuleConfiguration currentRuleConfig, boolean ifNotExists) {
        ReadwriteSplittingRuleStatementChecker.checkDuplicateRuleNames(database, segments, currentRuleConfig, ifNotExists);
        String databaseName = database.getName();
        ReadwriteSplittingRuleStatementChecker.checkDataSourcesExist(databaseName, segments, database);
        ReadwriteSplittingRuleStatementChecker.checkDuplicatedDataSourceNames(databaseName, segments, currentRuleConfig, true);
        ReadwriteSplittingRuleStatementChecker.checkTransactionalReadQueryStrategy(segments);
        ReadwriteSplittingRuleStatementChecker.checkLoadBalancers(segments);
    }

    public static void checkAlteration(ShardingSphereDatabase database, Collection<ReadwriteSplittingRuleSegment> segments, ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        String databaseName = database.getName();
        ReadwriteSplittingRuleStatementChecker.checkRuleConfigurationExist(database, currentRuleConfig);
        ReadwriteSplittingRuleStatementChecker.checkDuplicateRuleNamesWithSelf(databaseName, segments);
        ReadwriteSplittingRuleStatementChecker.checkRuleNamesExist(segments, currentRuleConfig, databaseName);
        ReadwriteSplittingRuleStatementChecker.checkDataSourcesExist(databaseName, segments, database);
        ReadwriteSplittingRuleStatementChecker.checkDuplicatedDataSourceNames(databaseName, segments, currentRuleConfig, false);
        ReadwriteSplittingRuleStatementChecker.checkTransactionalReadQueryStrategy(segments);
        ReadwriteSplittingRuleStatementChecker.checkLoadBalancers(segments);
    }

    public static void checkRuleConfigurationExist(ShardingSphereDatabase database, ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        ShardingSpherePreconditions.checkNotNull((Object)currentRuleConfig, () -> new MissingRequiredRuleException("Readwrite-splitting", database.getName()));
    }

    private static void checkRuleNamesExist(Collection<ReadwriteSplittingRuleSegment> segments, ReadwriteSplittingRuleConfiguration currentRuleConfig, String databaseName) {
        Collection requiredRuleNames = segments.stream().map(ReadwriteSplittingRuleSegment::getName).collect(Collectors.toList());
        Collection currentRuleNames = currentRuleConfig.getDataSources().stream().map(ReadwriteSplittingDataSourceRuleConfiguration::getName).collect(Collectors.toList());
        Collection notExistedRuleNames = requiredRuleNames.stream().filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkState((boolean)notExistedRuleNames.isEmpty(), () -> new MissingRequiredRuleException(databaseName, notExistedRuleNames));
    }

    private static void checkDuplicateRuleNames(ShardingSphereDatabase database, Collection<ReadwriteSplittingRuleSegment> segments, ReadwriteSplittingRuleConfiguration currentRuleConfig, boolean ifNotExists) {
        ReadwriteSplittingRuleStatementChecker.checkDuplicateRuleNamesWithSelf(database.getName(), segments);
        ReadwriteSplittingRuleStatementChecker.checkDuplicateRuleNamesWithExistsDataSources(database, segments);
        if (!ifNotExists) {
            ReadwriteSplittingRuleStatementChecker.checkDuplicateRuleNamesWithRuleConfiguration(database.getName(), currentRuleConfig, segments);
        }
    }

    private static void checkDuplicateRuleNamesWithSelf(String databaseName, Collection<ReadwriteSplittingRuleSegment> segments) {
        Collection<String> duplicatedRuleNames = ReadwriteSplittingRuleStatementChecker.getDuplicated(segments.stream().map(ReadwriteSplittingRuleSegment::getName).collect(Collectors.toList()));
        ShardingSpherePreconditions.checkState((boolean)duplicatedRuleNames.isEmpty(), () -> new DuplicateRuleException("Readwrite-splitting", databaseName, duplicatedRuleNames));
    }

    private static Collection<String> getDuplicated(Collection<String> required) {
        return required.stream().collect(Collectors.groupingBy(each -> each, Collectors.counting())).entrySet().stream().filter(each -> (Long)each.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static void checkDuplicateRuleNamesWithExistsDataSources(ShardingSphereDatabase database, Collection<ReadwriteSplittingRuleSegment> segments) {
        HashSet<Object> currentRuleNames = new HashSet<Object>();
        ResourceMetaData resourceMetaData = database.getResourceMetaData();
        if (null != resourceMetaData && null != resourceMetaData.getStorageUnitMetaData().getStorageUnits()) {
            currentRuleNames.addAll(resourceMetaData.getStorageUnitMetaData().getStorageUnits().keySet());
        }
        currentRuleNames.addAll(ReadwriteSplittingRuleStatementChecker.getLogicDataSources(database));
        Collection toBeCreatedRuleNames = segments.stream().map(ReadwriteSplittingRuleSegment::getName).filter(currentRuleNames::contains).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)toBeCreatedRuleNames.isEmpty(), () -> new InvalidRuleConfigurationException("Readwrite-splitting", toBeCreatedRuleNames, Collections.singleton(String.format("%s already exists in storage unit", toBeCreatedRuleNames))));
    }

    private static void checkDuplicateRuleNamesWithRuleConfiguration(String databaseName, ReadwriteSplittingRuleConfiguration currentRuleConfig, Collection<ReadwriteSplittingRuleSegment> segments) {
        LinkedList currentRuleNames = new LinkedList();
        if (null != currentRuleConfig) {
            currentRuleNames.addAll(currentRuleConfig.getDataSources().stream().map(ReadwriteSplittingDataSourceRuleConfiguration::getName).collect(Collectors.toList()));
        }
        Collection toBeCreatedRuleNames = segments.stream().map(ReadwriteSplittingRuleSegment::getName).filter(currentRuleNames::contains).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)toBeCreatedRuleNames.isEmpty(), () -> new DuplicateRuleException("Readwrite-splitting", databaseName, toBeCreatedRuleNames));
    }

    private static void checkDataSourcesExist(String databaseName, Collection<ReadwriteSplittingRuleSegment> segments, ShardingSphereDatabase database) {
        LinkedHashSet requiredDataSources = new LinkedHashSet();
        segments.forEach(each -> {
            requiredDataSources.add(each.getWriteDataSource());
            requiredDataSources.addAll(each.getReadDataSources());
        });
        Collection notExistedDataSources = database.getResourceMetaData().getNotExistedDataSources(requiredDataSources);
        ShardingSpherePreconditions.checkState((boolean)notExistedDataSources.isEmpty(), () -> new MissingRequiredStorageUnitsException(databaseName, notExistedDataSources));
    }

    private static Collection<String> getLogicDataSources(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findRules(DataSourceContainedRule.class).stream().map(each -> each.getDataSourceMapper().keySet()).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static void checkDuplicatedDataSourceNames(String databaseName, Collection<ReadwriteSplittingRuleSegment> segments, ReadwriteSplittingRuleConfiguration currentRuleConfig, boolean isCreating) {
        HashSet<String> existedWriteDataSourceNames = new HashSet<String>();
        HashSet<String> existedReadDataSourceNames = new HashSet<String>();
        if (null != currentRuleConfig) {
            Collection<Object> toBeAlteredRuleNames = isCreating ? Collections.emptySet() : ReadwriteSplittingRuleStatementChecker.getToBeAlteredRuleNames(segments);
            currentRuleConfig.getDataSources().forEach(each -> {
                if (!toBeAlteredRuleNames.contains(each.getName())) {
                    existedWriteDataSourceNames.add(each.getWriteDataSourceName());
                    existedReadDataSourceNames.addAll(each.getReadDataSourceNames());
                }
            });
        }
        ReadwriteSplittingRuleStatementChecker.checkDuplicateWriteDataSourceNames(databaseName, segments, existedWriteDataSourceNames);
        ReadwriteSplittingRuleStatementChecker.checkDuplicateReadDataSourceNames(databaseName, segments, existedReadDataSourceNames);
    }

    private static Collection<String> getToBeAlteredRuleNames(Collection<ReadwriteSplittingRuleSegment> segments) {
        return segments.stream().map(ReadwriteSplittingRuleSegment::getName).collect(Collectors.toSet());
    }

    private static void checkDuplicateWriteDataSourceNames(String databaseName, Collection<ReadwriteSplittingRuleSegment> segments, Collection<String> writeDataSourceNames) {
        segments.forEach(each -> {
            if (!Strings.isNullOrEmpty((String)each.getWriteDataSource())) {
                String writeDataSource = each.getWriteDataSource();
                ShardingSpherePreconditions.checkState((boolean)writeDataSourceNames.add(writeDataSource), () -> new InvalidRuleConfigurationException("Readwrite-splitting", each.getName(), String.format("Can not config duplicate write storage unit `%s` in database `%s`", writeDataSource, databaseName)));
            }
        });
    }

    private static void checkDuplicateReadDataSourceNames(String databaseName, Collection<ReadwriteSplittingRuleSegment> segments, Collection<String> readDataSourceNames) {
        for (ReadwriteSplittingRuleSegment each : segments) {
            if (null == each.getReadDataSources()) continue;
            ReadwriteSplittingRuleStatementChecker.checkDuplicateReadDataSourceNames(databaseName, each, readDataSourceNames);
        }
    }

    private static void checkDuplicateReadDataSourceNames(String databaseName, ReadwriteSplittingRuleSegment segment, Collection<String> readDataSourceNames) {
        for (String each : segment.getReadDataSources()) {
            ShardingSpherePreconditions.checkState((boolean)readDataSourceNames.add(each), () -> new InvalidRuleConfigurationException("Readwrite-splitting", segment.getName(), String.format("Can not config duplicate read storage unit `%s` in database `%s`.", each, databaseName)));
        }
    }

    private static void checkTransactionalReadQueryStrategy(Collection<ReadwriteSplittingRuleSegment> segments) {
        Collection validStrategyNames = Arrays.stream(TransactionalReadQueryStrategy.values()).map(Enum::name).collect(Collectors.toSet());
        for (ReadwriteSplittingRuleSegment each : segments) {
            if (null == each.getTransactionalReadQueryStrategy()) continue;
            ShardingSpherePreconditions.checkState((boolean)validStrategyNames.contains(each.getTransactionalReadQueryStrategy().toUpperCase()), () -> new InvalidRuleConfigurationException("Readwrite-splitting", each.getName(), String.format("Invalid transactional read query strategy `%s`.", each.getTransactionalReadQueryStrategy())));
        }
    }

    private static void checkLoadBalancers(Collection<ReadwriteSplittingRuleSegment> segments) {
        segments.stream().map(ReadwriteSplittingRuleSegment::getLoadBalancer).filter(Objects::nonNull).forEach(each -> TypedSPILoader.checkService(ReadQueryLoadBalanceAlgorithm.class, (Object)each.getName(), (Properties)each.getProps()));
    }

    @Generated
    private ReadwriteSplittingRuleStatementChecker() {
    }
}

