/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.distsql.handler.query.RQLExecutor;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.CountReadwriteSplittingRuleStatement;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;

public final class CountReadwriteSplittingRuleExecutor
implements RQLExecutor<CountReadwriteSplittingRuleStatement> {
    public Collection<String> getColumnNames() {
        return Arrays.asList("rule_name", "database", "count");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShardingSphereDatabase database, CountReadwriteSplittingRuleStatement sqlStatement) {
        Optional rule = database.getRuleMetaData().findSingleRule(ReadwriteSplittingRule.class);
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        rule.ifPresent(optional -> this.fillRows((Collection<LocalDataQueryResultRow>)result, (ReadwriteSplittingRule)optional, database.getName()));
        return result;
    }

    private void fillRows(Collection<LocalDataQueryResultRow> result, ReadwriteSplittingRule rule, String databaseName) {
        result.add(new LocalDataQueryResultRow(new Object[]{"readwrite_splitting", databaseName, rule.getDataSourceMapper().size()}));
    }

    public Class<CountReadwriteSplittingRuleStatement> getType() {
        return CountReadwriteSplittingRuleStatement.class;
    }
}

