/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.update;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.handler.checker.ReadwriteSplittingRuleStatementChecker;
import org.apache.shardingsphere.readwritesplitting.distsql.handler.converter.ReadwriteSplittingRuleStatementConverter;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.segment.ReadwriteSplittingRuleSegment;
import org.apache.shardingsphere.readwritesplitting.distsql.parser.statement.CreateReadwriteSplittingRuleStatement;

public final class CreateReadwriteSplittingRuleStatementUpdater
implements RuleDefinitionCreateUpdater<CreateReadwriteSplittingRuleStatement, ReadwriteSplittingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, CreateReadwriteSplittingRuleStatement sqlStatement, ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        ReadwriteSplittingRuleStatementChecker.checkCreation(database, sqlStatement.getRules(), currentRuleConfig, sqlStatement.isIfNotExists());
    }

    public ReadwriteSplittingRuleConfiguration buildToBeCreatedRuleConfiguration(ReadwriteSplittingRuleConfiguration currentRuleConfig, CreateReadwriteSplittingRuleStatement sqlStatement) {
        Collection segments = sqlStatement.getRules();
        if (sqlStatement.isIfNotExists()) {
            Collection<String> duplicatedRuleNames = this.getDuplicatedRuleNames(currentRuleConfig, sqlStatement.getRules());
            segments.removeIf(each -> duplicatedRuleNames.contains(each.getName()));
        }
        return ReadwriteSplittingRuleStatementConverter.convert(segments);
    }

    public void updateCurrentRuleConfiguration(ReadwriteSplittingRuleConfiguration currentRuleConfig, ReadwriteSplittingRuleConfiguration toBeCreatedRuleConfig) {
        currentRuleConfig.getDataSources().addAll(toBeCreatedRuleConfig.getDataSources());
        currentRuleConfig.getLoadBalancers().putAll(toBeCreatedRuleConfig.getLoadBalancers());
    }

    private Collection<String> getDuplicatedRuleNames(ReadwriteSplittingRuleConfiguration currentRuleConfig, Collection<ReadwriteSplittingRuleSegment> segments) {
        LinkedList currentRuleNames = new LinkedList();
        if (null != currentRuleConfig) {
            currentRuleNames.addAll(currentRuleConfig.getDataSources().stream().map(ReadwriteSplittingDataSourceRuleConfiguration::getName).collect(Collectors.toList()));
        }
        return segments.stream().map(ReadwriteSplittingRuleSegment::getName).filter(currentRuleNames::contains).collect(Collectors.toList());
    }

    public Class<ReadwriteSplittingRuleConfiguration> getRuleConfigurationClass() {
        return ReadwriteSplittingRuleConfiguration.class;
    }

    public Class<CreateReadwriteSplittingRuleStatement> getType() {
        return CreateReadwriteSplittingRuleStatement.class;
    }
}

