/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.converter;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.transaction.TransactionalReadQueryStrategy;
import org.apache.shardingsphere.readwritesplitting.distsql.segment.ReadwriteSplittingRuleSegment;

public final class ReadwriteSplittingRuleStatementConverter {
    public static ReadwriteSplittingRuleConfiguration convert(Collection<ReadwriteSplittingRuleSegment> ruleSegments) {
        LinkedList<ReadwriteSplittingDataSourceRuleConfiguration> dataSources = new LinkedList<ReadwriteSplittingDataSourceRuleConfiguration>();
        HashMap<String, AlgorithmConfiguration> loadBalancers = new HashMap<String, AlgorithmConfiguration>(ruleSegments.size(), 1.0f);
        for (ReadwriteSplittingRuleSegment each : ruleSegments) {
            if (null == each.getLoadBalancer()) {
                dataSources.add(ReadwriteSplittingRuleStatementConverter.createDataSourceRuleConfiguration(each, null));
                continue;
            }
            String loadBalancerName = ReadwriteSplittingRuleStatementConverter.getLoadBalancerName(each.getName(), each.getLoadBalancer().getName());
            loadBalancers.put(loadBalancerName, ReadwriteSplittingRuleStatementConverter.createLoadBalancer(each));
            dataSources.add(ReadwriteSplittingRuleStatementConverter.createDataSourceRuleConfiguration(each, loadBalancerName));
        }
        return new ReadwriteSplittingRuleConfiguration(dataSources, loadBalancers);
    }

    private static ReadwriteSplittingDataSourceRuleConfiguration createDataSourceRuleConfiguration(ReadwriteSplittingRuleSegment segment, String loadBalancerName) {
        return null == segment.getTransactionalReadQueryStrategy() ? new ReadwriteSplittingDataSourceRuleConfiguration(segment.getName(), segment.getWriteDataSource(), new LinkedList(segment.getReadDataSources()), loadBalancerName) : new ReadwriteSplittingDataSourceRuleConfiguration(segment.getName(), segment.getWriteDataSource(), new LinkedList(segment.getReadDataSources()), TransactionalReadQueryStrategy.valueOf((String)segment.getTransactionalReadQueryStrategy().toUpperCase()), loadBalancerName);
    }

    private static AlgorithmConfiguration createLoadBalancer(ReadwriteSplittingRuleSegment ruleSegment) {
        return new AlgorithmConfiguration(ruleSegment.getLoadBalancer().getName(), ruleSegment.getLoadBalancer().getProps());
    }

    private static String getLoadBalancerName(String ruleName, String type) {
        return String.format("%s_%s", ruleName, type);
    }

    @Generated
    private ReadwriteSplittingRuleStatementConverter() {
    }
}

