/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.query;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.shardingsphere.distsql.handler.executor.rql.resource.InUsedStorageUnitRetriever;
import org.apache.shardingsphere.distsql.statement.rql.rule.database.ShowRulesUsedStorageUnitStatement;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;

public final class InUsedReadwriteSplittingStorageUnitRetriever
implements InUsedStorageUnitRetriever<ReadwriteSplittingRule> {
    public Collection<String> getInUsedResources(ShowRulesUsedStorageUnitStatement sqlStatement, ReadwriteSplittingRule rule) {
        if (!sqlStatement.getStorageUnitName().isPresent()) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        for (ReadwriteSplittingDataSourceRuleConfiguration each : rule.getConfiguration().getDataSources()) {
            if (each.getWriteDataSourceName().equalsIgnoreCase((String)sqlStatement.getStorageUnitName().get())) {
                result.add(each.getName());
            }
            if (!new CaseInsensitiveSet((Collection)each.getReadDataSourceNames()).contains(sqlStatement.getStorageUnitName().get())) continue;
            result.add(each.getName());
        }
        return result;
    }

    public Class<ReadwriteSplittingRule> getType() {
        return ReadwriteSplittingRule.class;
    }
}

