/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.query;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.rule.attribute.exportable.ExportableRuleAttribute;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.statement.ShowReadwriteSplittingRulesStatement;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;

public final class ShowReadwriteSplittingRuleExecutor
implements DistSQLQueryExecutor<ShowReadwriteSplittingRulesStatement>,
DistSQLExecutorRuleAware<ReadwriteSplittingRule> {
    private ReadwriteSplittingRule rule;

    public Collection<String> getColumnNames(ShowReadwriteSplittingRulesStatement sqlStatement) {
        return Arrays.asList("name", "write_storage_unit_name", "read_storage_unit_names", "transactional_read_query_strategy", "load_balancer_type", "load_balancer_props");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowReadwriteSplittingRulesStatement sqlStatement, ContextManager contextManager) {
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        Map<String, Map<String, String>> exportableDataSourceMap = this.getExportableDataSourceMap(this.rule);
        ReadwriteSplittingRuleConfiguration ruleConfig = this.rule.getConfiguration();
        ruleConfig.getDataSources().forEach(each -> {
            LocalDataQueryResultRow dataItem = this.buildDataItem(exportableDataSourceMap, (ReadwriteSplittingDataSourceRuleConfiguration)each, this.getLoadBalancers(ruleConfig));
            if (null == sqlStatement.getRuleName() || sqlStatement.getRuleName().equalsIgnoreCase(each.getName())) {
                result.add(dataItem);
            }
        });
        return result;
    }

    private Map<String, Map<String, String>> getExportableDataSourceMap(ReadwriteSplittingRule rule) {
        return (Map)((ExportableRuleAttribute)rule.getAttributes().getAttribute(ExportableRuleAttribute.class)).getExportData().get("static_readwrite_splitting_rules");
    }

    private LocalDataQueryResultRow buildDataItem(Map<String, Map<String, String>> exportableDataSourceMap, ReadwriteSplittingDataSourceRuleConfiguration dataSourceRuleConfig, Map<String, AlgorithmConfiguration> loadBalancers) {
        String name = dataSourceRuleConfig.getName();
        Map<String, String> exportDataSources = exportableDataSourceMap.get(name);
        Optional<AlgorithmConfiguration> loadBalancer = Optional.ofNullable(loadBalancers.get(dataSourceRuleConfig.getLoadBalancerName()));
        return new LocalDataQueryResultRow(new Object[]{name, this.getWriteDataSourceName(dataSourceRuleConfig, exportDataSources), this.getReadDataSourceNames(dataSourceRuleConfig, exportDataSources), dataSourceRuleConfig.getTransactionalReadQueryStrategy().name(), loadBalancer.map(AlgorithmConfiguration::getType).orElse(null), loadBalancer.map(AlgorithmConfiguration::getProps).orElse(null)});
    }

    private Map<String, AlgorithmConfiguration> getLoadBalancers(ReadwriteSplittingRuleConfiguration ruleConfig) {
        Map loadBalancers = ruleConfig.getLoadBalancers();
        return null == loadBalancers ? Collections.emptyMap() : loadBalancers;
    }

    private String getWriteDataSourceName(ReadwriteSplittingDataSourceRuleConfiguration dataSourceRuleConfig, Map<String, String> exportDataSources) {
        return null == exportDataSources ? dataSourceRuleConfig.getWriteDataSourceName() : exportDataSources.get("primary_data_source_name");
    }

    private String getReadDataSourceNames(ReadwriteSplittingDataSourceRuleConfiguration dataSourceRuleConfig, Map<String, String> exportDataSources) {
        return null == exportDataSources ? Joiner.on((String)",").join((Iterable)dataSourceRuleConfig.getReadDataSourceNames()) : exportDataSources.get("replica_data_source_names");
    }

    public Class<ReadwriteSplittingRule> getRuleClass() {
        return ReadwriteSplittingRule.class;
    }

    public Class<ShowReadwriteSplittingRulesStatement> getType() {
        return ShowReadwriteSplittingRulesStatement.class;
    }

    @Generated
    public void setRule(ReadwriteSplittingRule rule) {
        this.rule = rule;
    }
}

