/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.state.datasource.DataSourceState;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.readwritesplitting.distsql.statement.ShowStatusFromReadwriteSplittingRulesStatement;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingDataSourceRule;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;

public final class ShowStatusFromReadwriteSplittingRulesExecutor
implements DistSQLQueryExecutor<ShowStatusFromReadwriteSplittingRulesStatement>,
DistSQLExecutorRuleAware<ReadwriteSplittingRule> {
    private ReadwriteSplittingRule rule;

    public Collection<String> getColumnNames(ShowStatusFromReadwriteSplittingRulesStatement sqlStatement) {
        return Arrays.asList("storage_unit", "status");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowStatusFromReadwriteSplittingRulesStatement sqlStatement, ContextManager contextManager) {
        Collection<ReadwriteSplittingDataSourceRule> dataSourceRules = this.getDataSourceRules(sqlStatement);
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        dataSourceRules.forEach(each -> result.addAll(this.buildRows((ReadwriteSplittingDataSourceRule)each)));
        return result;
    }

    private Collection<ReadwriteSplittingDataSourceRule> getDataSourceRules(ShowStatusFromReadwriteSplittingRulesStatement sqlStatement) {
        if (sqlStatement.getRuleName().isPresent()) {
            return this.rule.getDataSourceRules().values().stream().filter(each -> each.getName().equalsIgnoreCase((String)sqlStatement.getRuleName().get())).collect(Collectors.toList());
        }
        return this.rule.getDataSourceRules().values();
    }

    private Collection<LocalDataQueryResultRow> buildRows(ReadwriteSplittingDataSourceRule dataSourceRule) {
        return dataSourceRule.getReadwriteSplittingGroup().getReadDataSources().stream().map(each -> this.buildRow((String)each, dataSourceRule.getDisabledDataSourceNames().contains(each))).collect(Collectors.toList());
    }

    private LocalDataQueryResultRow buildRow(String dataSourceName, boolean disabled) {
        return new LocalDataQueryResultRow(new Object[]{dataSourceName, disabled ? DataSourceState.DISABLED : DataSourceState.ENABLED});
    }

    public Class<ReadwriteSplittingRule> getRuleClass() {
        return ReadwriteSplittingRule.class;
    }

    public Class<ShowStatusFromReadwriteSplittingRulesStatement> getType() {
        return ShowStatusFromReadwriteSplittingRulesStatement.class;
    }

    @Generated
    public void setRule(ReadwriteSplittingRule rule) {
        this.rule = rule;
    }
}

