/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.distsql.handler.update;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.InUsedRuleException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.datasource.DataSourceMapperRuleAttribute;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.distsql.statement.DropReadwriteSplittingRuleStatement;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;
import org.apache.shardingsphere.single.rule.SingleRule;

@DistSQLExecutorCurrentRuleRequired(value=ReadwriteSplittingRule.class)
public final class DropReadwriteSplittingRuleExecutor
implements DatabaseRuleDropExecutor<DropReadwriteSplittingRuleStatement, ReadwriteSplittingRule, ReadwriteSplittingRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ReadwriteSplittingRule rule;

    public void checkBeforeUpdate(DropReadwriteSplittingRuleStatement sqlStatement) {
        if (!sqlStatement.isIfExists()) {
            this.checkToBeDroppedRuleNames(sqlStatement);
        }
        this.checkToBeDroppedInUsed(sqlStatement);
    }

    private void checkToBeDroppedRuleNames(DropReadwriteSplittingRuleStatement sqlStatement) {
        Collection currentRuleNames = this.rule.getConfiguration().getDataSources().stream().map(ReadwriteSplittingDataSourceRuleConfiguration::getName).collect(Collectors.toList());
        Collection notExistedRuleNames = sqlStatement.getNames().stream().filter(each -> !currentRuleNames.contains(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)notExistedRuleNames.isEmpty(), () -> new MissingRequiredRuleException("Readwrite-splitting", this.database.getName(), sqlStatement.getNames()));
    }

    private void checkToBeDroppedInUsed(DropReadwriteSplittingRuleStatement sqlStatement) {
        Collection<String> resourceBeUsed = this.getInUsedResources();
        Collection ruleInUsed = sqlStatement.getNames().stream().filter(resourceBeUsed::contains).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkState((boolean)ruleInUsed.isEmpty(), () -> new InUsedRuleException("Readwrite-splitting", this.database.getName(), ruleInUsed));
    }

    private Collection<String> getInUsedResources() {
        HashSet<String> result = new HashSet<String>();
        for (ShardingSphereRule each : this.database.getRuleMetaData().getRules()) {
            Optional ruleAttribute;
            if (each instanceof ReadwriteSplittingRule || !(ruleAttribute = each.getAttributes().findAttribute(DataSourceMapperRuleAttribute.class)).isPresent()) continue;
            HashSet actualDataSources = new HashSet();
            ((DataSourceMapperRuleAttribute)ruleAttribute.get()).getDataSourceMapper().values().forEach(actualDataSources::addAll);
            result.addAll(actualDataSources);
        }
        for (ShardingSphereRule each : this.database.getRuleMetaData().getRules()) {
            if (each instanceof SingleRule) continue;
            HashSet actualDataNodes = new HashSet();
            Optional ruleAttribute = each.getAttributes().findAttribute(DataNodeRuleAttribute.class);
            if (!ruleAttribute.isPresent()) continue;
            ((DataNodeRuleAttribute)ruleAttribute.get()).getAllDataNodes().values().forEach(actualDataNodes::addAll);
            result.addAll(actualDataNodes.stream().map(DataNode::getDataSourceName).collect(Collectors.toSet()));
        }
        return result;
    }

    public ReadwriteSplittingRuleConfiguration buildToBeDroppedRuleConfiguration(DropReadwriteSplittingRuleStatement sqlStatement) {
        LinkedList<ReadwriteSplittingDataSourceRuleConfiguration> toBeDroppedDataSources = new LinkedList<ReadwriteSplittingDataSourceRuleConfiguration>();
        HashMap toBeDroppedLoadBalancers = new HashMap();
        for (String each2 : sqlStatement.getNames()) {
            toBeDroppedDataSources.add(new ReadwriteSplittingDataSourceRuleConfiguration(each2, null, null, null));
            this.dropRule(each2);
        }
        this.findUnusedLoadBalancers().forEach(each -> toBeDroppedLoadBalancers.put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getLoadBalancers().get(each)));
        return new ReadwriteSplittingRuleConfiguration(toBeDroppedDataSources, toBeDroppedLoadBalancers);
    }

    private void dropRule(String ruleName) {
        Optional<ReadwriteSplittingDataSourceRuleConfiguration> dataSourceRuleConfig = this.rule.getConfiguration().getDataSources().stream().filter(each -> ruleName.equals(each.getName())).findAny();
        dataSourceRuleConfig.ifPresent(optional -> this.rule.getConfiguration().getDataSources().remove(optional));
    }

    private Collection<String> findUnusedLoadBalancers() {
        Collection inUsedAlgorithms = this.rule.getConfiguration().getDataSources().stream().map(ReadwriteSplittingDataSourceRuleConfiguration::getLoadBalancerName).collect(Collectors.toSet());
        return this.rule.getConfiguration().getLoadBalancers().keySet().stream().filter(each -> !inUsedAlgorithms.contains(each)).collect(Collectors.toSet());
    }

    public boolean hasAnyOneToBeDropped(DropReadwriteSplittingRuleStatement sqlStatement) {
        return !Collections.disjoint(this.rule.getConfiguration().getDataSources().stream().map(ReadwriteSplittingDataSourceRuleConfiguration::getName).collect(Collectors.toSet()), sqlStatement.getNames());
    }

    public Class<ReadwriteSplittingRule> getRuleClass() {
        return ReadwriteSplittingRule.class;
    }

    public Class<DropReadwriteSplittingRuleStatement> getType() {
        return DropReadwriteSplittingRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ReadwriteSplittingRule rule) {
        this.rule = rule;
    }
}

