/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.replicaquery.algorithm;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.shardingsphere.replicaquery.spi.ReplicaLoadBalanceAlgorithm;

public final class RoundRobinReplicaLoadBalanceAlgorithm
implements ReplicaLoadBalanceAlgorithm {
    private static final ConcurrentHashMap<String, AtomicInteger> COUNTS = new ConcurrentHashMap();
    private Properties props = new Properties();

    public String getDataSource(String name, String primaryDataSourceName, List<String> replicaDataSourceNames) {
        AtomicInteger count = COUNTS.containsKey(name) ? COUNTS.get(name) : new AtomicInteger(0);
        COUNTS.putIfAbsent(name, count);
        count.compareAndSet(replicaDataSourceNames.size(), 0);
        return replicaDataSourceNames.get(Math.abs(count.getAndIncrement()) % replicaDataSourceNames.size());
    }

    public String getType() {
        return "ROUND_ROBIN";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

