/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.replicaquery.route.engine;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.schema.ShardingSphereSchema;
import org.apache.shardingsphere.replicaquery.route.engine.impl.ReplicaQueryDataSourceRouter;
import org.apache.shardingsphere.replicaquery.rule.ReplicaQueryDataSourceRule;
import org.apache.shardingsphere.replicaquery.rule.ReplicaQueryRule;

public final class ReplicaQuerySQLRouter
implements SQLRouter<ReplicaQueryRule> {
    public RouteContext createRouteContext(LogicSQL logicSQL, ShardingSphereSchema schema, ReplicaQueryRule rule, ConfigurationProperties props) {
        RouteContext result = new RouteContext();
        String dataSourceName = new ReplicaQueryDataSourceRouter(rule.getSingleDataSourceRule()).route(logicSQL.getSqlStatementContext().getSqlStatement());
        result.getRouteUnits().add(new RouteUnit(new RouteMapper("logic_db", dataSourceName), Collections.emptyList()));
        return result;
    }

    public void decorateRouteContext(RouteContext routeContext, LogicSQL logicSQL, ShardingSphereSchema schema, ReplicaQueryRule rule, ConfigurationProperties props) {
        LinkedList<RouteUnit> toBeRemoved = new LinkedList<RouteUnit>();
        LinkedList<RouteUnit> toBeAdded = new LinkedList<RouteUnit>();
        for (RouteUnit each : routeContext.getRouteUnits()) {
            String dataSourceName = each.getDataSourceMapper().getLogicName();
            Optional dataSourceRule = rule.findDataSourceRule(dataSourceName);
            if (!dataSourceRule.isPresent() || !((ReplicaQueryDataSourceRule)dataSourceRule.get()).getName().equalsIgnoreCase(each.getDataSourceMapper().getActualName())) continue;
            toBeRemoved.add(each);
            String actualDataSourceName = new ReplicaQueryDataSourceRouter((ReplicaQueryDataSourceRule)dataSourceRule.get()).route(logicSQL.getSqlStatementContext().getSqlStatement());
            toBeAdded.add(new RouteUnit(new RouteMapper(each.getDataSourceMapper().getLogicName(), actualDataSourceName), each.getTableMappers()));
        }
        routeContext.getRouteUnits().removeAll(toBeRemoved);
        routeContext.getRouteUnits().addAll(toBeAdded);
    }

    public int getOrder() {
        return 10;
    }

    public Class<ReplicaQueryRule> getTypeClass() {
        return ReplicaQueryRule.class;
    }
}

