/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.replicaquery.route.engine.impl;

import lombok.Generated;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.replicaquery.route.engine.impl.PrimaryVisitedManager;
import org.apache.shardingsphere.replicaquery.rule.ReplicaQueryDataSourceRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.SelectStatementHandler;

public final class ReplicaQueryDataSourceRouter {
    private final ReplicaQueryDataSourceRule rule;

    public String route(SQLStatement sqlStatement) {
        if (this.isPrimaryRoute(sqlStatement)) {
            PrimaryVisitedManager.setPrimaryVisited();
            return this.rule.getPrimaryDataSourceName();
        }
        return this.rule.getLoadBalancer().getDataSource(this.rule.getName(), this.rule.getPrimaryDataSourceName(), this.rule.getReplicaDataSourceNames());
    }

    private boolean isPrimaryRoute(SQLStatement sqlStatement) {
        return this.containsLockSegment(sqlStatement) || !(sqlStatement instanceof SelectStatement) || PrimaryVisitedManager.getPrimaryVisited() || HintManager.isPrimaryRouteOnly();
    }

    private boolean containsLockSegment(SQLStatement sqlStatement) {
        return sqlStatement instanceof SelectStatement && SelectStatementHandler.getLockSegment((SelectStatement)((SelectStatement)sqlStatement)).isPresent();
    }

    @Generated
    public ReplicaQueryDataSourceRouter(ReplicaQueryDataSourceRule rule) {
        this.rule = rule;
    }
}

