/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.condition;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;

public final class ShadowCondition {
    private final String columnName;
    private final int startIndex;
    private final int stopIndex;
    private final Map<Integer, Integer> positionIndexMap = new LinkedHashMap<Integer, Integer>();
    private final Map<Integer, Object> positionValueMap = new LinkedHashMap<Integer, Object>();

    public ShadowCondition(String columnName, int startIndex, int stopIndex, ExpressionSegment expressionSegment) {
        this.columnName = columnName;
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.putPositionMap(expressionSegment);
    }

    private void putPositionMap(ExpressionSegment expressionSegment) {
        if (expressionSegment instanceof ParameterMarkerExpressionSegment) {
            this.positionIndexMap.put(0, ((ParameterMarkerExpressionSegment)expressionSegment).getParameterMarkerIndex());
        } else if (expressionSegment instanceof LiteralExpressionSegment) {
            this.positionValueMap.put(0, ((LiteralExpressionSegment)expressionSegment).getLiterals());
        }
    }

    public List<Object> getValues(List<Object> parameters) {
        ArrayList<Object> result = new ArrayList<Object>(this.positionValueMap.values());
        for (Map.Entry<Integer, Integer> entry : this.positionIndexMap.entrySet()) {
            Object parameter = parameters.get(entry.getValue());
            if (entry.getKey() < result.size()) {
                result.add(entry.getKey(), parameter);
                continue;
            }
            result.add(parameter);
        }
        return result;
    }

    @Generated
    public String getColumnName() {
        return this.columnName;
    }

    @Generated
    public int getStartIndex() {
        return this.startIndex;
    }

    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }

    @Generated
    public Map<Integer, Integer> getPositionIndexMap() {
        return this.positionIndexMap;
    }

    @Generated
    public Map<Integer, Object> getPositionValueMap() {
        return this.positionValueMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShadowCondition)) {
            return false;
        }
        ShadowCondition other = (ShadowCondition)o;
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        if (this.getStartIndex() != other.getStartIndex()) {
            return false;
        }
        if (this.getStopIndex() != other.getStopIndex()) {
            return false;
        }
        Map<Integer, Integer> this$positionIndexMap = this.getPositionIndexMap();
        Map<Integer, Integer> other$positionIndexMap = other.getPositionIndexMap();
        if (this$positionIndexMap == null ? other$positionIndexMap != null : !((Object)this$positionIndexMap).equals(other$positionIndexMap)) {
            return false;
        }
        Map<Integer, Object> this$positionValueMap = this.getPositionValueMap();
        Map<Integer, Object> other$positionValueMap = other.getPositionValueMap();
        return !(this$positionValueMap == null ? other$positionValueMap != null : !((Object)this$positionValueMap).equals(other$positionValueMap));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        result = result * 59 + this.getStartIndex();
        result = result * 59 + this.getStopIndex();
        Map<Integer, Integer> $positionIndexMap = this.getPositionIndexMap();
        result = result * 59 + ($positionIndexMap == null ? 43 : ((Object)$positionIndexMap).hashCode());
        Map<Integer, Object> $positionValueMap = this.getPositionValueMap();
        result = result * 59 + ($positionValueMap == null ? 43 : ((Object)$positionValueMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ShadowCondition(columnName=" + this.getColumnName() + ", startIndex=" + this.getStartIndex() + ", stopIndex=" + this.getStopIndex() + ", positionIndexMap=" + this.getPositionIndexMap() + ", positionValueMap=" + this.getPositionValueMap() + ")";
    }
}

