/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.condition;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.shadow.condition.ShadowCondition;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionBuilder;

public final class ShadowConditionEngine {
    private final ShadowRule shadowRule;

    public Optional<ShadowCondition> createShadowCondition(SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof WhereAvailable)) {
            return Optional.empty();
        }
        Optional whereSegment = ((WhereAvailable)sqlStatementContext).getWhere();
        if (!whereSegment.isPresent()) {
            return Optional.empty();
        }
        ExpressionSegment expression = ((WhereSegment)((WhereAvailable)sqlStatementContext).getWhere().get()).getExpr();
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(expression);
        LinkedList andPredicates = new LinkedList(expressionBuilder.extractAndPredicates().getAndPredicates());
        for (AndPredicate each : andPredicates) {
            Optional<ShadowCondition> condition = this.createShadowCondition(each);
            if (!condition.isPresent()) continue;
            return condition;
        }
        return Optional.empty();
    }

    private Optional<ShadowCondition> createShadowCondition(AndPredicate andPredicate) {
        for (ExpressionSegment predicate : andPredicate.getPredicates()) {
            Optional<ShadowCondition> condition;
            HashSet<Integer> stopIndexes;
            Optional column = ColumnExtractor.extract((ExpressionSegment)predicate);
            if (!column.isPresent() || !(stopIndexes = new HashSet<Integer>()).add(predicate.getStopIndex()) || !(condition = this.shadowRule.getColumn().equals(((ColumnSegment)column.get()).getIdentifier().getValue()) ? this.createShadowCondition(predicate) : Optional.empty()).isPresent()) continue;
            return condition;
        }
        return Optional.empty();
    }

    private Optional<ShadowCondition> createShadowCondition(ExpressionSegment expression) {
        if (expression instanceof BinaryOperationExpression) {
            boolean logical;
            String operator = ((BinaryOperationExpression)expression).getOperator();
            boolean bl = logical = "and".equalsIgnoreCase(operator) || "&&".equalsIgnoreCase(operator) || "OR".equalsIgnoreCase(operator) || "||".equalsIgnoreCase(operator);
            if (!logical) {
                return this.isSupportedOperator(operator) ? ShadowConditionEngine.createCompareShadowCondition((BinaryOperationExpression)expression) : Optional.empty();
            }
        }
        if (expression instanceof InExpression) {
            throw new ShardingSphereException("The SQL clause 'IN...' is unsupported in shadow rule.", new Object[0]);
        }
        if (expression instanceof BetweenExpression) {
            throw new ShardingSphereException("The SQL clause 'BETWEEN...AND...' is unsupported in shadow rule.", new Object[0]);
        }
        return Optional.empty();
    }

    private static Optional<ShadowCondition> createCompareShadowCondition(BinaryOperationExpression expression) {
        if (!(expression.getLeft() instanceof ColumnSegment)) {
            return Optional.empty();
        }
        return expression.getRight() instanceof SimpleExpressionSegment ? Optional.of(new ShadowCondition(((ColumnSegment)expression.getLeft()).getIdentifier().getValue(), expression.getRight().getStartIndex(), expression.getStopIndex(), expression.getRight())) : Optional.empty();
    }

    private boolean isSupportedOperator(String operator) {
        return "=".equals(operator);
    }

    @Generated
    public ShadowConditionEngine(ShadowRule shadowRule) {
        this.shadowRule = shadowRule;
    }
}

