/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.update;

import java.util.Collection;
import java.util.Set;
import org.apache.shardingsphere.infra.config.scope.SchemaRuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.distsql.handler.checker.ShadowRuleStatementChecker;
import org.apache.shardingsphere.shadow.distsql.parser.statement.DropShadowRuleStatement;

public final class DropShadowRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropShadowRuleStatement, ShadowRuleConfiguration> {
    private static final String SHADOW = "shadow";

    public void checkSQLStatement(ShardingSphereMetaData metaData, DropShadowRuleStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = metaData.getName();
        this.checkConfigurationExist(schemaName, currentRuleConfig);
        this.checkRuleNames(schemaName, sqlStatement, currentRuleConfig);
    }

    private void checkConfigurationExist(String schemaName, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        ShadowRuleStatementChecker.checkConfigurationExist(schemaName, (SchemaRuleConfiguration)currentRuleConfig);
    }

    private void checkRuleNames(String schemaName, DropShadowRuleStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        Set<String> currentRuleNames = currentRuleConfig.getDataSources().keySet();
        ShadowRuleStatementChecker.checkRulesExist(currentRuleNames, sqlStatement.getRuleNames(), different -> new RequiredRuleMissedException(SHADOW, schemaName, (Collection)different));
    }

    public boolean updateCurrentRuleConfiguration(DropShadowRuleStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) {
        Collection ruleNames = sqlStatement.getRuleNames();
        ruleNames.forEach(each -> {
            ShadowDataSourceConfiguration cfr_ignored_0 = (ShadowDataSourceConfiguration)currentRuleConfig.getDataSources().remove(each);
        });
        currentRuleConfig.getTables().forEach((key, value) -> value.getDataSourceNames().removeIf(ruleNames::contains));
        return false;
    }

    public Class<ShadowRuleConfiguration> getRuleConfigurationClass() {
        return ShadowRuleConfiguration.class;
    }

    public String getType() {
        return DropShadowRuleStatement.class.getCanonicalName();
    }
}

