/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.distsql.parser.statement.ShowShadowRulesStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShadowRuleQueryResultSet
implements DistSQLResultSet {
    private static final String RULE_NAME = "rule_name";
    private static final String SOURCE_NAME = "source_name";
    private static final String SHADOW_NAME = "shadow_name";
    private static final String SHADOW_TABLE = "shadow_table";
    private Iterator<Map<String, String>> data = Collections.emptyIterator();

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        Optional<ShadowRuleConfiguration> ruleConfigurations = metaData.getRuleMetaData().getConfigurations().stream().filter(each -> each instanceof ShadowRuleConfiguration).map(each -> (ShadowRuleConfiguration)each).findAny();
        ruleConfigurations.ifPresent(configuration -> this.buildDataSourceIterator((ShadowRuleConfiguration)configuration, (ShowShadowRulesStatement)sqlStatement));
    }

    private void buildDataSourceIterator(ShadowRuleConfiguration configuration, ShowShadowRulesStatement sqlStatement) {
        Map<String, Map<String, ShadowTableConfiguration>> dataSourceTableMap = this.convertToDataSourceTableMap(configuration.getTables());
        Set specifiedConfigurations = !this.isSpecified(sqlStatement) ? configuration.getDataSources().entrySet() : (Collection)configuration.getDataSources().entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(sqlStatement.getRuleName())).collect(Collectors.toList());
        this.data = specifiedConfigurations.stream().map(each -> this.buildDataItem((Map.Entry<String, ShadowDataSourceConfiguration>)each, dataSourceTableMap)).collect(Collectors.toList()).iterator();
    }

    private Map<String, Map<String, ShadowTableConfiguration>> convertToDataSourceTableMap(Map<String, ShadowTableConfiguration> tables) {
        Map<String, Map<String, ShadowTableConfiguration>> result = tables.values().stream().map(ShadowTableConfiguration::getDataSourceNames).flatMap(Collection::stream).distinct().collect(Collectors.toMap(each -> each, each -> new LinkedHashMap()));
        tables.forEach((key, value) -> value.getDataSourceNames().forEach(each -> ((Map)result.get(each)).put(key, value)));
        return result;
    }

    private boolean isSpecified(ShowShadowRulesStatement sqlStatement) {
        return null != sqlStatement.getRuleName() && !sqlStatement.getRuleName().isEmpty();
    }

    private Map<String, String> buildDataItem(Map.Entry<String, ShadowDataSourceConfiguration> dataSource, Map<String, Map<String, ShadowTableConfiguration>> dataSourceTableMap) {
        Map<String, String> result = this.convertToDataSourceMap(dataSource);
        Map dataSourceTable = dataSourceTableMap.getOrDefault(result.get(RULE_NAME), Collections.emptyMap());
        result.put(SHADOW_TABLE, this.convertToString(dataSourceTable.keySet()));
        return result;
    }

    private Map<String, String> convertToDataSourceMap(Map.Entry<String, ShadowDataSourceConfiguration> dataSource) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(RULE_NAME, dataSource.getKey());
        result.put(SOURCE_NAME, dataSource.getValue().getSourceDataSourceName());
        result.put(SHADOW_NAME, dataSource.getValue().getShadowDataSourceName());
        return result;
    }

    private String convertToString(Collection<String> shadowTables) {
        if (null != shadowTables) {
            return String.join((CharSequence)",", shadowTables);
        }
        return "";
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList(RULE_NAME, SOURCE_NAME, SHADOW_NAME, SHADOW_TABLE);
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.buildRowData(this.data.next());
    }

    private Collection<Object> buildRowData(Map<String, String> data) {
        return Arrays.asList(data.get(RULE_NAME), data.get(SOURCE_NAME), data.get(SHADOW_NAME), data.getOrDefault(SHADOW_TABLE, ""));
    }

    public String getType() {
        return ShowShadowRulesStatement.class.getName();
    }
}

