/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.judge.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.shadow.route.engine.judge.ShadowDataSourceJudgeEngine;
import org.apache.shardingsphere.shadow.route.engine.judge.util.ShadowValueJudgeUtil;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionBuilder;

public final class PreparedShadowDataSourceJudgeEngine
implements ShadowDataSourceJudgeEngine {
    private final ShadowRule shadowRule;
    private final SQLStatementContext<?> sqlStatementContext;
    private final List<Object> parameters;

    @Override
    public boolean isShadow() {
        if (this.sqlStatementContext instanceof InsertStatementContext) {
            Collection columnSegments = ((InsertStatement)((InsertStatementContext)this.sqlStatementContext).getSqlStatement()).getColumns();
            int count = 0;
            for (ColumnSegment each : columnSegments) {
                if (each.getIdentifier().getValue().equals(this.shadowRule.getColumn())) {
                    return ShadowValueJudgeUtil.isShadowValue(this.parameters.get(count));
                }
                ++count;
            }
            return false;
        }
        if (!(this.sqlStatementContext instanceof WhereAvailable)) {
            return false;
        }
        Optional whereSegment = ((WhereAvailable)this.sqlStatementContext).getWhere();
        if (!whereSegment.isPresent()) {
            return false;
        }
        ExpressionSegment expression = ((WhereSegment)whereSegment.get()).getExpr();
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(expression);
        LinkedList andPredicates = new LinkedList(expressionBuilder.extractAndPredicates().getAndPredicates());
        for (AndPredicate andPredicate : andPredicates) {
            if (!this.judgePredicateSegments(andPredicate.getPredicates())) continue;
            return true;
        }
        return false;
    }

    private boolean judgePredicateSegments(Collection<ExpressionSegment> predicates) {
        for (ExpressionSegment each : predicates) {
            if (!(each instanceof BinaryOperationExpression)) continue;
            BinaryOperationExpression expression = (BinaryOperationExpression)each;
            ColumnSegment column = null;
            ExpressionSegment right = null;
            if (expression.getLeft() instanceof ColumnSegment) {
                column = (ColumnSegment)((BinaryOperationExpression)each).getLeft();
                right = ((BinaryOperationExpression)each).getRight();
            }
            if (null == column || !column.getIdentifier().getValue().equals(this.shadowRule.getColumn())) continue;
            Preconditions.checkArgument((boolean)(each instanceof BinaryOperationExpression), (Object)"must be BinaryOperationExpression");
            if (right instanceof LiteralExpressionSegment) {
                return ShadowValueJudgeUtil.isShadowValue(((LiteralExpressionSegment)right).getLiterals());
            }
            if (!(right instanceof ParameterMarkerExpressionSegment)) continue;
            int parameterMarkerIndex = ((ParameterMarkerExpressionSegment)right).getParameterMarkerIndex();
            return ShadowValueJudgeUtil.isShadowValue(this.parameters.get(parameterMarkerIndex));
        }
        return false;
    }

    @Generated
    public PreparedShadowDataSourceJudgeEngine(ShadowRule shadowRule, SQLStatementContext<?> sqlStatementContext, List<Object> parameters) {
        this.shadowRule = shadowRule;
        this.sqlStatementContext = sqlStatementContext;
        this.parameters = parameters;
    }
}

