/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cache.rule.builder;

import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.database.DatabaseRuleBuilder;
import org.apache.shardingsphere.infra.rule.identifier.scope.DatabaseRule;
import org.apache.shardingsphere.sharding.cache.api.ShardingCacheRuleConfiguration;
import org.apache.shardingsphere.sharding.cache.rule.ShardingCacheRule;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.timeservice.core.rule.TimeServiceRule;

public final class ShardingCacheRuleBuilder
implements DatabaseRuleBuilder<ShardingCacheRuleConfiguration> {
    public DatabaseRule build(ShardingCacheRuleConfiguration config, String databaseName, Map<String, DataSource> dataSources, Collection<ShardingSphereRule> builtRules, InstanceContext instanceContext) {
        ShardingRule shardingRule = (ShardingRule)builtRules.stream().filter(ShardingRule.class::isInstance).findFirst().orElseThrow(() -> new IllegalStateException("ShardingCacheRule requires ShardingRule"));
        TimeServiceRule timeServiceRule = (TimeServiceRule)builtRules.stream().filter(TimeServiceRule.class::isInstance).findFirst().orElseThrow(() -> new IllegalStateException("ShardingCacheRule requires TimeServiceRule"));
        return new ShardingCacheRule(config, shardingRule, timeServiceRule);
    }

    public int getOrder() {
        return -9;
    }

    public Class<ShardingCacheRuleConfiguration> getTypeClass() {
        return ShardingCacheRuleConfiguration.class;
    }
}

