/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.algorithm.sharding.datetime;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public final class AutoIntervalShardingAlgorithm
implements StandardShardingAlgorithm<Comparable<?>>,
ShardingAutoTableAlgorithm {
    private static final String DATE_TIME_LOWER_KEY = "datetime-lower";
    private static final String DATE_TIME_UPPER_KEY = "datetime-upper";
    private static final String SHARDING_SECONDS_KEY = "sharding-seconds";
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private Properties props = new Properties();
    private LocalDateTime dateTimeLower;
    private long shardingSeconds;
    private int autoTablesAmount;

    public void init() {
        this.dateTimeLower = this.getDateTime(DATE_TIME_LOWER_KEY);
        this.shardingSeconds = this.getShardingSeconds();
        this.autoTablesAmount = (int)(Math.ceil(this.parseDate((Comparable<?>)((Object)this.props.getProperty(DATE_TIME_UPPER_KEY))) / this.shardingSeconds) + 2.0);
    }

    private LocalDateTime getDateTime(String dateTimeKey) {
        String value = this.props.getProperty(dateTimeKey);
        Preconditions.checkNotNull((Object)value, (String)"%s cannot be null.", (Object)dateTimeKey);
        try {
            return LocalDateTime.parse(value, DATE_TIME_FORMAT);
        }
        catch (DateTimeParseException ex) {
            throw new ShardingSphereConfigurationException("Invalid %s, datetime pattern should be `yyyy-MM-dd HH:mm:ss`, value is `%s`", new Object[]{dateTimeKey, value});
        }
    }

    private long getShardingSeconds() {
        Preconditions.checkArgument((boolean)this.props.containsKey(SHARDING_SECONDS_KEY), (String)"%s cannot be null.", (Object)SHARDING_SECONDS_KEY);
        return Long.parseLong(this.props.getProperty(SHARDING_SECONDS_KEY));
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        for (String each : availableTargetNames) {
            if (!each.endsWith(String.valueOf(this.doSharding(this.parseDate(shardingValue.getValue()))))) continue;
            return each;
        }
        return null;
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(availableTargetNames.size());
        int firstPartition = this.getFirstPartition(shardingValue.getValueRange());
        int lastPartition = this.getLastPartition(shardingValue.getValueRange());
        for (int i = firstPartition; i <= lastPartition; ++i) {
            for (String each : availableTargetNames) {
                if (each.endsWith(String.valueOf(i))) {
                    result.add(each);
                }
                if (result.size() != availableTargetNames.size()) continue;
                return result;
            }
        }
        return result;
    }

    private int doSharding(long shardingValue) {
        String position = new DecimalFormat("0.00").format((float)shardingValue / (float)this.shardingSeconds);
        return Math.min(Math.max(0, (int)Math.ceil(Float.parseFloat(position))), this.autoTablesAmount - 1);
    }

    private int getFirstPartition(Range<Comparable<?>> valueRange) {
        return valueRange.hasLowerBound() ? this.doSharding(this.parseDate(valueRange.lowerEndpoint())) : 0;
    }

    private int getLastPartition(Range<Comparable<?>> valueRange) {
        return valueRange.hasUpperBound() ? this.doSharding(this.parseDate(valueRange.upperEndpoint())) : this.autoTablesAmount - 1;
    }

    private long parseDate(Comparable<?> shardingValue) {
        LocalDateTime dateValue = LocalDateTime.parse(shardingValue.toString(), DATE_TIME_FORMAT);
        return Duration.between(this.dateTimeLower, dateValue).toMillis() / 1000L;
    }

    public String getType() {
        return "AUTO_INTERVAL";
    }

    public Collection<String> getAllPropertyKeys() {
        return Arrays.asList(DATE_TIME_LOWER_KEY, DATE_TIME_UPPER_KEY, SHARDING_SECONDS_KEY);
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public LocalDateTime getDateTimeLower() {
        return this.dateTimeLower;
    }

    @Generated
    public int getAutoTablesAmount() {
        return this.autoTablesAmount;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

