/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.converter;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.segment.rdl.TableRuleSegment;
import org.apache.shardingsphere.distsql.parser.statement.rdl.CreateShardingRuleStatement;
import org.apache.shardingsphere.infra.binder.statement.rdl.CreateShardingRuleStatementContext;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmPropertiesAware;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.yaml.config.algorithm.YamlShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;
import org.apache.shardingsphere.sharding.yaml.config.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.rule.YamlShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.strategy.sharding.YamlShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.strategy.sharding.YamlStandardShardingStrategyConfiguration;

public final class CreateShardingRuleStatementContextConverter {
    public static YamlShardingRuleConfiguration convert(CreateShardingRuleStatementContext sqlStatementContext) {
        YamlShardingRuleConfiguration result = new YamlShardingRuleConfiguration();
        for (TableRuleSegment each : ((CreateShardingRuleStatement)sqlStatementContext.getSqlStatement()).getTables()) {
            result.getShardingAlgorithms().put(CreateShardingRuleStatementContextConverter.getAlgorithmName(each.getLogicTable(), each.getAlgorithmType()), CreateShardingRuleStatementContextConverter.createAlgorithmConfiguration(each, CreateShardingRuleStatementContextConverter.getAlgorithmProperties(each.getAlgorithmType(), each.getProperties())));
            result.getAutoTables().put(each.getLogicTable(), CreateShardingRuleStatementContextConverter.createAutoTableRuleConfiguration(each));
        }
        return result;
    }

    private static YamlShardingSphereAlgorithmConfiguration createAlgorithmConfiguration(TableRuleSegment segment, Properties properties) {
        YamlShardingSphereAlgorithmConfiguration result = new YamlShardingSphereAlgorithmConfiguration();
        result.setType(segment.getAlgorithmType());
        result.setProps(properties);
        return result;
    }

    private static Properties getAlgorithmProperties(String type, Collection<String> propertyValues) {
        Collection<String> propertyKeys = CreateShardingRuleStatementContextConverter.findAlgorithmPropertyKeys(type);
        Preconditions.checkArgument((propertyKeys.size() == propertyValues.size() ? 1 : 0) != 0, (String)"%s needs %d properties, but %s properties are given.", (Object)type, (Object)propertyKeys.size(), (Object)propertyValues.size());
        Properties result = new Properties();
        Iterator<String> keys = propertyKeys.iterator();
        Iterator<String> values = propertyValues.iterator();
        while (keys.hasNext()) {
            result.setProperty(keys.next(), values.next());
        }
        return result;
    }

    private static Collection<String> findAlgorithmPropertyKeys(String algorithmType) {
        return ShardingSphereServiceLoader.newServiceInstances(ShardingAlgorithm.class).stream().filter(each -> each instanceof ShardingAutoTableAlgorithm && each.getType().equals(algorithmType)).findFirst().map(each -> ((ShardingSphereAlgorithmPropertiesAware)each).getAllPropertyKeys()).orElse(Collections.emptyList());
    }

    private static YamlShardingAutoTableRuleConfiguration createAutoTableRuleConfiguration(TableRuleSegment segment) {
        YamlShardingAutoTableRuleConfiguration result = new YamlShardingAutoTableRuleConfiguration();
        result.setLogicTable(segment.getLogicTable());
        result.setActualDataSources(Joiner.on((String)",").join((Iterable)segment.getDataSources()));
        result.setShardingStrategy(CreateShardingRuleStatementContextConverter.createStrategyConfiguration(segment));
        return result;
    }

    private static YamlShardingStrategyConfiguration createStrategyConfiguration(TableRuleSegment segment) {
        YamlShardingStrategyConfiguration result = new YamlShardingStrategyConfiguration();
        YamlStandardShardingStrategyConfiguration standard = new YamlStandardShardingStrategyConfiguration();
        standard.setShardingColumn(segment.getShardingColumn());
        standard.setShardingAlgorithmName(CreateShardingRuleStatementContextConverter.getAlgorithmName(segment.getLogicTable(), segment.getAlgorithmType()));
        result.setStandard(standard);
        return result;
    }

    private static String getAlgorithmName(String tableName, String algorithmType) {
        return String.format("%s_%s", tableName, algorithmType);
    }

    @Generated
    private CreateShardingRuleStatementContextConverter() {
    }
}

