/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cosid.algorithm.keygen;

import java.util.Properties;
import me.ahoo.cosid.provider.LazyIdGenerator;
import org.apache.shardingsphere.sharding.spi.KeyGenerateAlgorithm;

public final class CosIdKeyGenerateAlgorithm
implements KeyGenerateAlgorithm {
    private static final String AS_STRING_KEY = "as-string";
    private LazyIdGenerator lazyIdGenerator;
    private boolean asString;

    public void init(Properties props) {
        this.lazyIdGenerator = new LazyIdGenerator(props.getProperty("id-name", "__share__"));
        this.asString = Boolean.parseBoolean(props.getProperty(AS_STRING_KEY, Boolean.FALSE.toString()));
        this.lazyIdGenerator.tryGet(false);
    }

    public Comparable<?> generateKey() {
        if (this.asString) {
            return this.lazyIdGenerator.generateAsString();
        }
        return this.lazyIdGenerator.generate();
    }

    public String getType() {
        return "cosid".toUpperCase();
    }
}

