/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cosid.algorithm.sharding.interval;

import java.time.ZoneId;
import java.util.Properties;
import me.ahoo.cosid.sharding.LocalDateTimeConvertor;
import me.ahoo.cosid.sharding.SnowflakeLocalDateTimeConvertor;
import me.ahoo.cosid.snowflake.MillisecondSnowflakeIdStateParser;
import me.ahoo.cosid.snowflake.SnowflakeIdStateParser;
import org.apache.shardingsphere.sharding.cosid.algorithm.keygen.CosIdSnowflakeKeyGenerateAlgorithm;
import org.apache.shardingsphere.sharding.cosid.algorithm.sharding.interval.AbstractCosIdIntervalShardingAlgorithm;

public final class CosIdSnowflakeIntervalShardingAlgorithm
extends AbstractCosIdIntervalShardingAlgorithm<Comparable<?>> {
    private static final String EPOCH_KEY = "epoch";
    private static final String ZONE_ID_KEY = "zone-id";

    @Override
    protected LocalDateTimeConvertor createLocalDateTimeConvertor(Properties props) {
        return new SnowflakeLocalDateTimeConvertor(this.createSnowflakeIdStateParser(props));
    }

    private SnowflakeIdStateParser createSnowflakeIdStateParser(Properties props) {
        long epoch = Long.parseLong(props.getProperty(EPOCH_KEY, String.valueOf(CosIdSnowflakeKeyGenerateAlgorithm.DEFAULT_EPOCH)));
        ZoneId zoneId = props.containsKey(ZONE_ID_KEY) ? ZoneId.of(props.getProperty(ZONE_ID_KEY)) : ZoneId.systemDefault();
        return new MillisecondSnowflakeIdStateParser(epoch, 41, 10, 12, zoneId);
    }

    public String getType() {
        return "COSID_INTERVAL_SNOWFLAKE";
    }
}

