/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.DropShardingBroadcastTableRulesStatement;

public final class DropShardingBroadcastTableRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropShardingBroadcastTableRulesStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, DropShardingBroadcastTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkCurrentRuleConfiguration(schemaName, currentRuleConfig);
        this.checkBroadCastTableRuleExist(schemaName, sqlStatement, currentRuleConfig);
    }

    private void checkBroadCastTableRuleExist(String schemaName, DropShardingBroadcastTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (!sqlStatement.getRules().isEmpty()) {
            Collection currentRules = currentRuleConfig.getBroadcastTables();
            LinkedList notExistRules = sqlStatement.getRules().stream().filter(each -> !currentRules.contains(each)).collect(Collectors.toCollection(LinkedList::new));
            DistSQLException.predictionThrow((boolean)notExistRules.isEmpty(), (DistSQLException)new RequiredRuleMissedException("Broadcast", schemaName, (Collection)notExistRules));
        }
    }

    private void checkCurrentRuleConfiguration(String schemaName, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((null != currentRuleConfig ? 1 : 0) != 0, (DistSQLException)new RequiredRuleMissedException("Broadcast", schemaName));
    }

    public boolean updateCurrentRuleConfiguration(DropShardingBroadcastTableRulesStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) {
        if (sqlStatement.getRules().isEmpty()) {
            currentRuleConfig.getBroadcastTables().clear();
        } else {
            currentRuleConfig.getBroadcastTables().removeIf(sqlStatement.getRules()::contains);
        }
        return false;
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return DropShardingBroadcastTableRulesStatement.class.getCanonicalName();
    }
}

