/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.scaling.distsql.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import org.apache.shardingsphere.data.pipeline.spi.check.consistency.DataConsistencyCheckAlgorithm;
import org.apache.shardingsphere.data.pipeline.spi.detect.JobCompletionDetectAlgorithm;
import org.apache.shardingsphere.data.pipeline.spi.ingest.channel.PipelineChannelFactory;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.config.rulealtered.OnRuleAlteredActionConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.scaling.distsql.handler.converter.ShardingScalingRuleStatementConverter;
import org.apache.shardingsphere.scaling.distsql.statement.CreateShardingScalingRuleStatement;
import org.apache.shardingsphere.scaling.distsql.statement.segment.ShardingScalingRuleConfigurationSegment;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.spi.singleton.SingletonSPI;
import org.apache.shardingsphere.spi.singleton.TypedSingletonSPIHolder;
import org.apache.shardingsphere.spi.typed.TypedSPI;

public final class CreateShardingScalingRuleStatementUpdater
implements RuleDefinitionCreateUpdater<CreateShardingScalingRuleStatement, ShardingRuleConfiguration> {
    private static final TypedSingletonSPIHolder<JobRateLimitAlgorithm> RATE_LIMIT_ALGORITHM_HOLDER = new TypedSingletonSPIHolder(JobRateLimitAlgorithm.class, false);
    private static final TypedSingletonSPIHolder<PipelineChannelFactory> PIPELINE_CHANNEL_FACTORY_HOLDER = new TypedSingletonSPIHolder(PipelineChannelFactory.class, false);
    private static final TypedSingletonSPIHolder<JobCompletionDetectAlgorithm> COMPLETION_DETECT_ALGORITHM_HOLDER = new TypedSingletonSPIHolder(JobCompletionDetectAlgorithm.class, false);
    private static final TypedSingletonSPIHolder<DataConsistencyCheckAlgorithm> DATA_CONSISTENCY_CHECK_ALGORITHM_HOLDER = new TypedSingletonSPIHolder(DataConsistencyCheckAlgorithm.class, false);

    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, CreateShardingScalingRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkCurrentRuleConfiguration(schemaName, currentRuleConfig);
        this.checkDuplicate(schemaName, sqlStatement, currentRuleConfig);
        this.checkAlgorithms(sqlStatement);
    }

    private void checkCurrentRuleConfiguration(String schemaName, ShardingRuleConfiguration currentRuleConfig) throws RequiredRuleMissedException {
        if (null == currentRuleConfig) {
            throw new RequiredRuleMissedException("Sharding", schemaName);
        }
    }

    private void checkDuplicate(String schemaName, CreateShardingScalingRuleStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (currentRuleConfig.getScaling().containsKey(sqlStatement.getScalingName())) {
            throw new DuplicateRuleException("Scaling", schemaName, Collections.singletonList(sqlStatement.getScalingName()));
        }
    }

    private void checkAlgorithms(CreateShardingScalingRuleStatement sqlStatement) throws DistSQLException {
        if (null == sqlStatement.getConfigurationSegment()) {
            return;
        }
        this.checkRateLimiterExist(sqlStatement.getConfigurationSegment());
        this.checkStreamChannelExist(sqlStatement.getConfigurationSegment());
        this.checkCompletionDetectorExist(sqlStatement.getConfigurationSegment());
        this.checkDataConsistencyCheckerExist(sqlStatement.getConfigurationSegment());
    }

    private void checkRateLimiterExist(ShardingScalingRuleConfigurationSegment segment) throws DistSQLException {
        if (null != segment.getInputSegment()) {
            this.checkRateLimiterAlgorithm(segment.getInputSegment().getRateLimiter());
        }
        if (null != segment.getOutputSegment()) {
            this.checkRateLimiterAlgorithm(segment.getOutputSegment().getRateLimiter());
        }
    }

    private void checkRateLimiterAlgorithm(AlgorithmSegment rateLimiter) throws DistSQLException {
        this.checkAlgorithm(RATE_LIMIT_ALGORITHM_HOLDER, "rate limiter", rateLimiter);
    }

    private void checkStreamChannelExist(ShardingScalingRuleConfigurationSegment segment) throws DistSQLException {
        if (null != segment.getStreamChannel()) {
            this.checkAlgorithm(PIPELINE_CHANNEL_FACTORY_HOLDER, "stream channel", segment.getStreamChannel());
        }
    }

    private void checkCompletionDetectorExist(ShardingScalingRuleConfigurationSegment segment) throws DistSQLException {
        if (null != segment.getCompletionDetector()) {
            this.checkAlgorithm(COMPLETION_DETECT_ALGORITHM_HOLDER, "completion detector", segment.getCompletionDetector());
        }
    }

    private void checkDataConsistencyCheckerExist(ShardingScalingRuleConfigurationSegment segment) throws DistSQLException {
        if (null != segment.getDataConsistencyChecker()) {
            this.checkAlgorithm(DATA_CONSISTENCY_CHECK_ALGORITHM_HOLDER, "data consistency checker", segment.getDataConsistencyChecker());
        }
    }

    private <T extends TypedSPI & SingletonSPI> void checkAlgorithm(TypedSingletonSPIHolder<T> singletonSPIHolder, String algorithmType, AlgorithmSegment segment) throws DistSQLException {
        Optional service = singletonSPIHolder.get(segment.getName());
        if (!service.isPresent()) {
            throw new InvalidAlgorithmConfigurationException(algorithmType, segment.getName());
        }
    }

    public ShardingRuleConfiguration buildToBeCreatedRuleConfiguration(CreateShardingScalingRuleStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        HashMap<String, OnRuleAlteredActionConfiguration> scalingConfigurationMap = new HashMap<String, OnRuleAlteredActionConfiguration>(1, 1.0f);
        scalingConfigurationMap.put(sqlStatement.getScalingName(), this.buildScalingConfiguration(sqlStatement.getConfigurationSegment()));
        result.setScaling(scalingConfigurationMap);
        return result;
    }

    private OnRuleAlteredActionConfiguration buildScalingConfiguration(ShardingScalingRuleConfigurationSegment segment) {
        if (null == segment) {
            return this.buildNullScalingConfiguration();
        }
        return ShardingScalingRuleStatementConverter.convert(segment);
    }

    private OnRuleAlteredActionConfiguration buildNullScalingConfiguration() {
        return null;
    }

    public void updateCurrentRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeCreatedRuleConfig) {
        currentRuleConfig.getScaling().putAll(toBeCreatedRuleConfig.getScaling());
        if (null == currentRuleConfig.getScalingName()) {
            currentRuleConfig.setScalingName((String)toBeCreatedRuleConfig.getScaling().keySet().iterator().next());
        }
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return CreateShardingScalingRuleStatement.class.getName();
    }
}

