/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowShardingKeyGeneratorsStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShardingKeyGeneratorsQueryResultSet
implements DistSQLResultSet {
    private Iterator<Map.Entry<String, ShardingSphereAlgorithmConfiguration>> data = Collections.emptyIterator();

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        metaData.getRuleMetaData().findRuleConfiguration(ShardingRuleConfiguration.class).forEach(each -> {
            this.data = each.getKeyGenerators().entrySet().iterator();
        });
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "type", "props");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        Map.Entry<String, ShardingSphereAlgorithmConfiguration> entry = this.data.next();
        return Arrays.asList(entry.getKey(), entry.getValue().getType(), entry.getValue().getProps());
    }

    public String getType() {
        return ShowShardingKeyGeneratorsStatement.class.getName();
    }
}

