/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.checker;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.exception.algorithm.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.distsql.handler.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.distsql.handler.exception.rule.InvalidRuleConfigurationException;
import org.apache.shardingsphere.distsql.handler.exception.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.distsql.handler.exception.storageunit.MissingRequiredStorageUnitsException;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.expr.core.InlineExpressionParserFactory;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingAutoTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.sharding.ShardingAutoTableAlgorithm;
import org.apache.shardingsphere.sharding.distsql.handler.converter.ShardingTableRuleStatementConverter;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyType;
import org.apache.shardingsphere.sharding.distsql.parser.segment.strategy.AuditStrategySegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.strategy.KeyGenerateStrategySegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.strategy.ShardingAuditorSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.strategy.ShardingStrategySegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.table.AbstractTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.table.AutoTableRuleSegment;
import org.apache.shardingsphere.sharding.distsql.parser.segment.table.TableRuleSegment;
import org.apache.shardingsphere.sharding.exception.algorithm.sharding.ShardingAlgorithmClassImplementationException;
import org.apache.shardingsphere.sharding.exception.metadata.ShardingTableRuleNotFoundException;
import org.apache.shardingsphere.sharding.exception.strategy.InvalidShardingStrategyConfigurationException;
import org.apache.shardingsphere.sharding.rule.BindingTableCheckedConfiguration;
import org.apache.shardingsphere.sharding.rule.TableRule;
import org.apache.shardingsphere.sharding.spi.KeyGenerateAlgorithm;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;
import org.apache.shardingsphere.sharding.spi.ShardingAuditAlgorithm;

public final class ShardingTableRuleStatementChecker {
    private static final String DELIMITER = ".";

    public static void checkCreation(ShardingSphereDatabase database, Collection<AbstractTableRuleSegment> rules, boolean ifNotExists, ShardingRuleConfiguration currentRuleConfig) {
        ShardingTableRuleStatementChecker.check(database, rules, ifNotExists, currentRuleConfig, true);
    }

    public static void checkAlteration(ShardingSphereDatabase database, Collection<AbstractTableRuleSegment> rules, ShardingRuleConfiguration currentRuleConfig) {
        ShardingTableRuleStatementChecker.check(database, rules, false, currentRuleConfig, false);
    }

    public static boolean isValidBindingTableGroups(Collection<ShardingTableReferenceRuleConfiguration> bindingTableGroups, ShardingRuleConfiguration currentRuleConfig) {
        ShardingRuleConfiguration toBeCheckedRuleConfig = ShardingTableRuleStatementChecker.createToBeCheckedShardingRuleConfiguration(currentRuleConfig);
        toBeCheckedRuleConfig.setBindingTableGroups(bindingTableGroups);
        Collection<String> dataSourceNames = ShardingTableRuleStatementChecker.getRequiredDataSources(toBeCheckedRuleConfig);
        dataSourceNames.addAll(ShardingTableRuleStatementChecker.getRequiredDataSources(currentRuleConfig));
        return ShardingTableRuleStatementChecker.check(toBeCheckedRuleConfig, dataSourceNames);
    }

    private static ShardingRuleConfiguration createToBeCheckedShardingRuleConfiguration(ShardingRuleConfiguration currentRuleConfig) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        result.setTables(new LinkedList(currentRuleConfig.getTables()));
        result.setAutoTables(new LinkedList(currentRuleConfig.getAutoTables()));
        result.setBindingTableGroups(new LinkedList(currentRuleConfig.getBindingTableGroups()));
        result.setDefaultTableShardingStrategy(currentRuleConfig.getDefaultTableShardingStrategy());
        result.setDefaultDatabaseShardingStrategy(currentRuleConfig.getDefaultDatabaseShardingStrategy());
        result.setDefaultKeyGenerateStrategy(currentRuleConfig.getDefaultKeyGenerateStrategy());
        result.setDefaultShardingColumn(currentRuleConfig.getDefaultShardingColumn());
        result.setShardingAlgorithms(new LinkedHashMap(currentRuleConfig.getShardingAlgorithms()));
        result.setKeyGenerators(new LinkedHashMap(currentRuleConfig.getKeyGenerators()));
        result.setAuditors(new LinkedHashMap(currentRuleConfig.getAuditors()));
        return result;
    }

    private static void check(ShardingSphereDatabase database, Collection<AbstractTableRuleSegment> rules, boolean ifNotExists, ShardingRuleConfiguration currentRuleConfig, boolean isCreated) {
        String databaseName = database.getName();
        ShardingTableRuleStatementChecker.checkTables(databaseName, rules, currentRuleConfig, isCreated, ifNotExists);
        ShardingTableRuleStatementChecker.checkDataSources(databaseName, rules, database);
        ShardingTableRuleStatementChecker.checkKeyGenerators(rules);
        ShardingTableRuleStatementChecker.checkAuditors(rules);
        ShardingTableRuleStatementChecker.checkAutoTableRule(rules.stream().filter(AutoTableRuleSegment.class::isInstance).map(AutoTableRuleSegment.class::cast).collect(Collectors.toList()));
        ShardingTableRuleStatementChecker.checkTableRule(databaseName, rules.stream().filter(TableRuleSegment.class::isInstance).map(TableRuleSegment.class::cast).collect(Collectors.toList()));
        if (!isCreated) {
            ShardingTableRuleStatementChecker.checkBindingTableRules(rules, currentRuleConfig);
        }
    }

    private static boolean check(ShardingRuleConfiguration checkedConfig, Collection<String> dataSourceNames) {
        Collection<String> allDataSourceNames = ShardingTableRuleStatementChecker.getDataSourceNames(checkedConfig.getTables(), checkedConfig.getAutoTables(), dataSourceNames);
        HashMap<String, ShardingAlgorithm> shardingAlgorithms = new HashMap<String, ShardingAlgorithm>(checkedConfig.getShardingAlgorithms().size(), 1.0f);
        HashMap<String, TableRule> tableRules = new HashMap<String, TableRule>();
        checkedConfig.getShardingAlgorithms().forEach((key, value) -> shardingAlgorithms.put((String)key, (ShardingAlgorithm)TypedSPILoader.getService(ShardingAlgorithm.class, (Object)value.getType(), (Properties)value.getProps())));
        tableRules.putAll(ShardingTableRuleStatementChecker.createTableRules(checkedConfig.getTables(), checkedConfig.getDefaultKeyGenerateStrategy(), allDataSourceNames));
        tableRules.putAll(ShardingTableRuleStatementChecker.createAutoTableRules(checkedConfig.getAutoTables(), shardingAlgorithms, checkedConfig.getDefaultKeyGenerateStrategy(), allDataSourceNames));
        NoneShardingStrategyConfiguration defaultDatabaseShardingStrategyConfig = null == checkedConfig.getDefaultDatabaseShardingStrategy() ? new NoneShardingStrategyConfiguration() : checkedConfig.getDefaultDatabaseShardingStrategy();
        NoneShardingStrategyConfiguration defaultTableShardingStrategyConfig = null == checkedConfig.getDefaultTableShardingStrategy() ? new NoneShardingStrategyConfiguration() : checkedConfig.getDefaultTableShardingStrategy();
        return ShardingTableRuleStatementChecker.isValidBindingTableConfiguration(tableRules, new BindingTableCheckedConfiguration(allDataSourceNames, shardingAlgorithms, checkedConfig.getBindingTableGroups(), (ShardingStrategyConfiguration)defaultDatabaseShardingStrategyConfig, (ShardingStrategyConfiguration)defaultTableShardingStrategyConfig, checkedConfig.getDefaultShardingColumn()));
    }

    private static Collection<String> getDataSourceNames(Collection<ShardingTableRuleConfiguration> tableRuleConfigs, Collection<ShardingAutoTableRuleConfiguration> autoTableRuleConfigs, Collection<String> dataSourceNames) {
        if (tableRuleConfigs.isEmpty() && autoTableRuleConfigs.isEmpty()) {
            return dataSourceNames;
        }
        if (tableRuleConfigs.stream().map(ShardingTableRuleConfiguration::getActualDataNodes).anyMatch(each -> null == each || each.isEmpty())) {
            return dataSourceNames;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        tableRuleConfigs.forEach(each -> result.addAll(ShardingTableRuleStatementChecker.getDataSourceNames(each)));
        autoTableRuleConfigs.forEach(each -> result.addAll(InlineExpressionParserFactory.newInstance((String)each.getActualDataSources()).splitAndEvaluate()));
        return result;
    }

    private static Collection<String> getDataSourceNames(ShardingTableRuleConfiguration shardingTableRuleConfig) {
        return InlineExpressionParserFactory.newInstance((String)shardingTableRuleConfig.getActualDataNodes()).splitAndEvaluate().stream().map(each -> new DataNode(each).getDataSourceName()).collect(Collectors.toList());
    }

    private static Collection<String> getDataSourceNames(Collection<String> actualDataNodes) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String each : actualDataNodes) {
            result.add(ShardingTableRuleStatementChecker.isValidDataNode(each) ? new DataNode(each).getDataSourceName() : each);
        }
        return result;
    }

    private static boolean isValidDataNode(String dataNodeStr) {
        return dataNodeStr.contains(DELIMITER) && 2 == Splitter.on((String)DELIMITER).omitEmptyStrings().splitToList((CharSequence)dataNodeStr).size();
    }

    private static Map<String, TableRule> createTableRules(Collection<ShardingTableRuleConfiguration> tableRuleConfigs, KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig, Collection<String> dataSourceNames) {
        return tableRuleConfigs.stream().map(each -> new TableRule(each, dataSourceNames, ShardingTableRuleStatementChecker.getDefaultGenerateKeyColumn(defaultKeyGenerateStrategyConfig))).collect(Collectors.toMap(each -> each.getLogicTable().toLowerCase(), Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private static String getDefaultGenerateKeyColumn(KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig) {
        return Optional.ofNullable(defaultKeyGenerateStrategyConfig).map(KeyGenerateStrategyConfiguration::getColumn).orElse(null);
    }

    private static Map<String, TableRule> createAutoTableRules(Collection<ShardingAutoTableRuleConfiguration> autoTableRuleConfigs, Map<String, ShardingAlgorithm> shardingAlgorithms, KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig, Collection<String> dataSourceNames) {
        return autoTableRuleConfigs.stream().map(each -> ShardingTableRuleStatementChecker.createAutoTableRule(defaultKeyGenerateStrategyConfig, each, shardingAlgorithms, dataSourceNames)).collect(Collectors.toMap(each -> each.getLogicTable().toLowerCase(), Function.identity(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private static TableRule createAutoTableRule(KeyGenerateStrategyConfiguration defaultKeyGenerateStrategyConfig, ShardingAutoTableRuleConfiguration autoTableRuleConfig, Map<String, ShardingAlgorithm> shardingAlgorithms, Collection<String> dataSourceNames) {
        ShardingAlgorithm shardingAlgorithm = shardingAlgorithms.get(autoTableRuleConfig.getShardingStrategy().getShardingAlgorithmName());
        ShardingSpherePreconditions.checkState((boolean)(shardingAlgorithm instanceof ShardingAutoTableAlgorithm), () -> new ShardingAlgorithmClassImplementationException(autoTableRuleConfig.getShardingStrategy().getShardingAlgorithmName(), ShardingAutoTableAlgorithm.class));
        return new TableRule(autoTableRuleConfig, dataSourceNames, (ShardingAutoTableAlgorithm)shardingAlgorithm, ShardingTableRuleStatementChecker.getDefaultGenerateKeyColumn(defaultKeyGenerateStrategyConfig));
    }

    private static boolean isValidBindingTableConfiguration(Map<String, TableRule> tableRules, BindingTableCheckedConfiguration checkedConfig) {
        for (ShardingTableReferenceRuleConfiguration each : checkedConfig.getBindingTableGroups()) {
            List bindingTables = Splitter.on((String)",").trimResults().splitToList((CharSequence)each.getReference().toLowerCase());
            if (bindingTables.size() <= 1) {
                return false;
            }
            Iterator iterator = bindingTables.iterator();
            TableRule sampleTableRule = ShardingTableRuleStatementChecker.getTableRule((String)iterator.next(), tableRules);
            while (iterator.hasNext()) {
                TableRule tableRule = ShardingTableRuleStatementChecker.getTableRule((String)iterator.next(), tableRules);
                if (!ShardingTableRuleStatementChecker.isValidActualDataSourceName(sampleTableRule, tableRule) || !ShardingTableRuleStatementChecker.isValidActualTableName(sampleTableRule, tableRule)) {
                    return false;
                }
                if (!ShardingTableRuleStatementChecker.isInvalidShardingAlgorithm(sampleTableRule, tableRule, true, checkedConfig) && !ShardingTableRuleStatementChecker.isInvalidShardingAlgorithm(sampleTableRule, tableRule, false, checkedConfig)) continue;
                return false;
            }
        }
        return true;
    }

    private static TableRule getTableRule(String logicTableName, Map<String, TableRule> tableRules) {
        TableRule result = tableRules.get(logicTableName);
        if (null != result) {
            return result;
        }
        throw new ShardingTableRuleNotFoundException(Collections.singleton(logicTableName));
    }

    private static boolean isValidActualDataSourceName(TableRule sampleTableRule, TableRule tableRule) {
        return sampleTableRule.getActualDataSourceNames().equals(tableRule.getActualDataSourceNames());
    }

    private static boolean isValidActualTableName(TableRule sampleTableRule, TableRule tableRule) {
        for (String each : sampleTableRule.getActualDataSourceNames()) {
            Collection actualTableNames;
            Collection sampleActualTableNames = sampleTableRule.getActualTableNames(each).stream().map(actualTableName -> actualTableName.replace(sampleTableRule.getTableDataNode().getPrefix(), "")).collect(Collectors.toSet());
            if (sampleActualTableNames.equals(actualTableNames = (Collection)tableRule.getActualTableNames(each).stream().map(optional -> optional.replace(tableRule.getTableDataNode().getPrefix(), "")).collect(Collectors.toSet()))) continue;
            return false;
        }
        return true;
    }

    private static boolean isInvalidShardingAlgorithm(TableRule sampleTableRule, TableRule tableRule, boolean databaseAlgorithm, BindingTableCheckedConfiguration checkedConfig) {
        return !ShardingTableRuleStatementChecker.getAlgorithmExpression(sampleTableRule, databaseAlgorithm, checkedConfig).equals(ShardingTableRuleStatementChecker.getAlgorithmExpression(tableRule, databaseAlgorithm, checkedConfig));
    }

    private static Optional<String> getAlgorithmExpression(TableRule tableRule, boolean databaseAlgorithm, BindingTableCheckedConfiguration checkedConfig) {
        ShardingStrategyConfiguration shardingStrategyConfig = databaseAlgorithm ? ShardingTableRuleStatementChecker.getDatabaseShardingStrategyConfiguration(tableRule, checkedConfig) : ShardingTableRuleStatementChecker.getTableShardingStrategyConfiguration(tableRule, checkedConfig);
        ShardingAlgorithm shardingAlgorithm = (ShardingAlgorithm)checkedConfig.getShardingAlgorithms().get(shardingStrategyConfig.getShardingAlgorithmName());
        String dataNodePrefix = databaseAlgorithm ? tableRule.getDataSourceDataNode().getPrefix() : tableRule.getTableDataNode().getPrefix();
        String shardingColumn = ShardingTableRuleStatementChecker.getShardingColumn(shardingStrategyConfig, checkedConfig.getDefaultShardingColumn());
        return null == shardingAlgorithm ? Optional.empty() : shardingAlgorithm.getAlgorithmStructure(dataNodePrefix, shardingColumn);
    }

    private static ShardingStrategyConfiguration getDatabaseShardingStrategyConfiguration(TableRule tableRule, BindingTableCheckedConfiguration checkedConfig) {
        return null == tableRule.getDatabaseShardingStrategyConfig() ? checkedConfig.getDefaultDatabaseShardingStrategyConfig() : tableRule.getDatabaseShardingStrategyConfig();
    }

    private static ShardingStrategyConfiguration getTableShardingStrategyConfiguration(TableRule tableRule, BindingTableCheckedConfiguration checkedConfig) {
        return null == tableRule.getTableShardingStrategyConfig() ? checkedConfig.getDefaultTableShardingStrategyConfig() : tableRule.getTableShardingStrategyConfig();
    }

    private static String getShardingColumn(ShardingStrategyConfiguration shardingStrategyConfig, String defaultShardingColumn) {
        String shardingColumn = defaultShardingColumn;
        if (shardingStrategyConfig instanceof ComplexShardingStrategyConfiguration) {
            shardingColumn = ((ComplexShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumns();
        }
        if (shardingStrategyConfig instanceof StandardShardingStrategyConfiguration) {
            shardingColumn = ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn();
        }
        return null == shardingColumn ? "" : shardingColumn;
    }

    private static void checkDataSources(String databaseName, Collection<AbstractTableRuleSegment> rules, ShardingSphereDatabase database) {
        Collection<String> requiredDataSource = ShardingTableRuleStatementChecker.getRequiredDataSources(rules);
        Collection notExistedDataSources = database.getResourceMetaData().getNotExistedDataSources(requiredDataSource);
        Collection<String> logicDataSources = ShardingTableRuleStatementChecker.getLogicDataSources(database);
        notExistedDataSources.removeIf(logicDataSources::contains);
        ShardingSpherePreconditions.checkState((boolean)notExistedDataSources.isEmpty(), () -> new MissingRequiredStorageUnitsException(databaseName, notExistedDataSources));
    }

    private static Collection<String> getRequiredDataSources(ShardingRuleConfiguration config) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(config.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getActualDataSources).map(each -> Splitter.on((String)",").trimResults().splitToList((CharSequence)each)).flatMap(Collection::stream).collect(Collectors.toSet()));
        result.addAll(config.getTables().stream().map(each -> InlineExpressionParserFactory.newInstance((String)each.getActualDataNodes()).splitAndEvaluate()).flatMap(Collection::stream).distinct().map(each -> new DataNode(each).getDataSourceName()).collect(Collectors.toSet()));
        return result;
    }

    private static <T extends AbstractTableRuleSegment> Collection<String> getRequiredDataSources(Collection<T> rules) {
        return rules.stream().map(AbstractTableRuleSegment::getDataSourceNodes).flatMap(Collection::stream).map(ShardingTableRuleStatementChecker::parseDateSource).map(ShardingTableRuleStatementChecker::getDataSourceNames).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static Collection<String> parseDateSource(String dateSource) {
        return InlineExpressionParserFactory.newInstance((String)dateSource).splitAndEvaluate();
    }

    private static Collection<String> getLogicDataSources(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findRules(DataSourceContainedRule.class).stream().map(each -> each.getDataSourceMapper().keySet()).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static void checkTables(String databaseName, Collection<AbstractTableRuleSegment> rules, ShardingRuleConfiguration currentRuleConfig, boolean isCreate, boolean ifNotExists) {
        List<String> currentShardingTables;
        Collection requiredTables = rules.stream().map(AbstractTableRuleSegment::getLogicTable).collect(Collectors.toList());
        Collection<String> duplicatedRuleNames = ShardingTableRuleStatementChecker.getDuplicatedRuleNames(requiredTables);
        ShardingSpherePreconditions.checkState((boolean)duplicatedRuleNames.isEmpty(), () -> new DuplicateRuleException("sharding", databaseName, duplicatedRuleNames));
        Collection<Object> collection = currentShardingTables = null == currentRuleConfig ? Collections.emptyList() : ShardingTableRuleStatementChecker.getCurrentShardingTables(currentRuleConfig);
        if (isCreate) {
            if (!ifNotExists) {
                duplicatedRuleNames.addAll(ShardingTableRuleStatementChecker.getDuplicatedRuleNames(requiredTables, currentShardingTables));
                ShardingSpherePreconditions.checkState((boolean)duplicatedRuleNames.isEmpty(), () -> new DuplicateRuleException("sharding", databaseName, duplicatedRuleNames));
            }
        } else {
            Set<String> notExistsRules = ShardingTableRuleStatementChecker.getNotExistsRules(requiredTables, currentShardingTables);
            ShardingSpherePreconditions.checkState((boolean)notExistsRules.isEmpty(), () -> new MissingRequiredRuleException("sharding", databaseName, notExistsRules));
        }
    }

    private static Collection<String> getDuplicatedRuleNames(Collection<String> collection) {
        Collection duplicate = collection.stream().collect(Collectors.groupingBy(String::toLowerCase, Collectors.counting())).entrySet().stream().filter(each -> (Long)each.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        return collection.stream().filter(each -> ShardingTableRuleStatementChecker.containsIgnoreCase(duplicate, each)).collect(Collectors.toSet());
    }

    private static Collection<String> getDuplicatedRuleNames(Collection<String> require, Collection<String> current) {
        return require.stream().filter(each -> ShardingTableRuleStatementChecker.containsIgnoreCase(current, each)).collect(Collectors.toSet());
    }

    private static Set<String> getNotExistsRules(Collection<String> require, Collection<String> current) {
        return require.stream().filter(each -> !ShardingTableRuleStatementChecker.containsIgnoreCase(current, each)).collect(Collectors.toSet());
    }

    private static boolean containsIgnoreCase(Collection<String> collection, String str) {
        return collection.stream().anyMatch(each -> each.equalsIgnoreCase(str));
    }

    private static Collection<String> getCurrentShardingTables(ShardingRuleConfiguration currentRuleConfig) {
        LinkedList<String> result = new LinkedList<String>();
        result.addAll(currentRuleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        result.addAll(currentRuleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toSet()));
        return result;
    }

    private static void checkKeyGenerators(Collection<AbstractTableRuleSegment> rules) {
        rules.stream().map(AbstractTableRuleSegment::getKeyGenerateStrategySegment).filter(Objects::nonNull).map(KeyGenerateStrategySegment::getKeyGenerateAlgorithmSegment).forEach(each -> TypedSPILoader.checkService(KeyGenerateAlgorithm.class, (Object)each.getName(), (Properties)each.getProps()));
    }

    private static void checkAuditors(Collection<AbstractTableRuleSegment> rules) {
        Collection auditStrategySegments = rules.stream().map(AbstractTableRuleSegment::getAuditStrategySegment).filter(Objects::nonNull).collect(Collectors.toList());
        LinkedHashSet requiredAuditors = new LinkedHashSet();
        for (AuditStrategySegment each2 : auditStrategySegments) {
            requiredAuditors.addAll(each2.getAuditorSegments().stream().map(ShardingAuditorSegment::getAlgorithmSegment).collect(Collectors.toList()));
        }
        requiredAuditors.forEach(each -> TypedSPILoader.checkService(ShardingAuditAlgorithm.class, (Object)each.getName(), (Properties)each.getProps()));
    }

    private static void checkAutoTableRule(Collection<AutoTableRuleSegment> autoTableRules) {
        ShardingTableRuleStatementChecker.checkAutoTableShardingAlgorithms(autoTableRules);
    }

    private static void checkAutoTableShardingAlgorithms(Collection<AutoTableRuleSegment> autoTableRules) {
        autoTableRules.forEach(each -> {
            ShardingSpherePreconditions.checkState((boolean)TypedSPILoader.findService(ShardingAlgorithm.class, (Object)each.getShardingAlgorithmSegment().getName(), (Properties)each.getShardingAlgorithmSegment().getProps()).isPresent(), () -> new InvalidAlgorithmConfigurationException("sharding", each.getShardingAlgorithmSegment().getName()));
            ShardingAlgorithm shardingAlgorithm = (ShardingAlgorithm)TypedSPILoader.getService(ShardingAlgorithm.class, (Object)each.getShardingAlgorithmSegment().getName(), (Properties)each.getShardingAlgorithmSegment().getProps());
            ShardingSpherePreconditions.checkState((boolean)(shardingAlgorithm instanceof ShardingAutoTableAlgorithm), () -> new InvalidAlgorithmConfigurationException("sharding", shardingAlgorithm.getType(), String.format("auto sharding algorithm is required for rule `%s`", each.getLogicTable())));
        });
    }

    private static void checkTableRule(String databaseName, Collection<TableRuleSegment> tableRules) {
        ShardingTableRuleStatementChecker.checkStrategy(databaseName, tableRules);
    }

    private static void checkStrategy(String databaseName, Collection<TableRuleSegment> rules) {
        for (TableRuleSegment each : rules) {
            Optional<ShardingStrategySegment> tableStrategySegment;
            Optional<ShardingStrategySegment> databaseStrategySegment = Optional.ofNullable(each.getDatabaseStrategySegment());
            if (databaseStrategySegment.isPresent()) {
                if ("none".equalsIgnoreCase(databaseStrategySegment.get().getType())) {
                    Collection<String> requiredDataSources = ShardingTableRuleStatementChecker.getRequiredDataSources(rules);
                    ShardingSpherePreconditions.checkState((1 == requiredDataSources.size() ? 1 : 0) != 0, () -> new InvalidShardingStrategyConfigurationException("database", ((ShardingStrategySegment)databaseStrategySegment.get()).getType(), "strategy does not match data nodes"));
                } else {
                    AlgorithmSegment databaseShardingAlgorithm = databaseStrategySegment.get().getShardingAlgorithm();
                    ShardingTableRuleStatementChecker.checkDatabaseShardingAlgorithm(databaseName, each, databaseShardingAlgorithm);
                }
            }
            if (!(tableStrategySegment = Optional.ofNullable(each.getTableStrategySegment())).isPresent()) continue;
            if ("none".equalsIgnoreCase(tableStrategySegment.get().getType())) {
                Collection<String> requiredTables = ShardingTableRuleStatementChecker.getRequiredTables(rules);
                ShardingSpherePreconditions.checkState((1 == requiredTables.size() ? 1 : 0) != 0, () -> new InvalidShardingStrategyConfigurationException("table", ((ShardingStrategySegment)tableStrategySegment.get()).getType(), "strategy does not match data nodes"));
                continue;
            }
            AlgorithmSegment tableShardingAlgorithm = tableStrategySegment.get().getShardingAlgorithm();
            ShardingTableRuleStatementChecker.checkTableShardingAlgorithm(databaseName, each, tableShardingAlgorithm);
        }
    }

    private static void checkDatabaseShardingAlgorithm(String databaseName, TableRuleSegment each, AlgorithmSegment databaseShardingAlgorithm) {
        if (null != databaseShardingAlgorithm) {
            ShardingAlgorithm shardingAlgorithm = (ShardingAlgorithm)TypedSPILoader.getService(ShardingAlgorithm.class, (Object)databaseShardingAlgorithm.getName(), (Properties)databaseShardingAlgorithm.getProps());
            ShardingSpherePreconditions.checkState((!(shardingAlgorithm instanceof ShardingAutoTableAlgorithm) ? 1 : 0) != 0, () -> new InvalidAlgorithmConfigurationException("sharding", shardingAlgorithm.getType(), String.format("auto sharding algorithm cannot be used to create a table in Table mode `%s`", each.getLogicTable())));
        }
        ShardingSpherePreconditions.checkState((boolean)ShardingTableRuleStatementChecker.isValidStrategy(each.getDatabaseStrategySegment()), () -> new InvalidAlgorithmConfigurationException(databaseName, null == databaseShardingAlgorithm ? null : databaseShardingAlgorithm.getName()));
    }

    private static void checkTableShardingAlgorithm(String databaseName, TableRuleSegment each, AlgorithmSegment tableShardingAlgorithm) {
        if (null != tableShardingAlgorithm) {
            ShardingAlgorithm shardingAlgorithm = (ShardingAlgorithm)TypedSPILoader.getService(ShardingAlgorithm.class, (Object)tableShardingAlgorithm.getName(), (Properties)tableShardingAlgorithm.getProps());
            ShardingSpherePreconditions.checkState((!(shardingAlgorithm instanceof ShardingAutoTableAlgorithm) ? 1 : 0) != 0, () -> new InvalidAlgorithmConfigurationException("sharding", shardingAlgorithm.getType(), String.format("auto sharding algorithm cannot be used to create a table in Table mode `%s`", each.getLogicTable())));
        }
        ShardingSpherePreconditions.checkState((boolean)ShardingTableRuleStatementChecker.isValidStrategy(each.getTableStrategySegment()), () -> new InvalidAlgorithmConfigurationException(databaseName, null == tableShardingAlgorithm ? null : tableShardingAlgorithm.getName()));
    }

    private static boolean isValidStrategy(ShardingStrategySegment shardingStrategySegment) {
        return ShardingStrategyType.getValueOf(shardingStrategySegment.getType()).isValid(shardingStrategySegment.getShardingColumn()) && null != shardingStrategySegment.getShardingAlgorithm();
    }

    private static Collection<String> getRequiredTables(Collection<TableRuleSegment> rules) {
        return rules.stream().map(AbstractTableRuleSegment::getDataSourceNodes).flatMap(Collection::stream).map(ShardingTableRuleStatementChecker::parseDateSource).map(ShardingTableRuleStatementChecker::getTableNames).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static Collection<String> getTableNames(Collection<String> actualDataNodes) {
        HashSet<String> result = new HashSet<String>();
        for (String each : actualDataNodes) {
            result.add(ShardingTableRuleStatementChecker.isValidDataNode(each) ? new DataNode(each).getTableName() : each);
        }
        return result;
    }

    private static void checkBindingTableRules(Collection<AbstractTableRuleSegment> rules, ShardingRuleConfiguration currentRuleConfig) {
        if (null == currentRuleConfig || currentRuleConfig.getBindingTableGroups().isEmpty()) {
            return;
        }
        Collection<String> bindingTables = ShardingTableRuleStatementChecker.getCurrentBindingTables(currentRuleConfig);
        if (bindingTables.size() <= 1) {
            return;
        }
        ShardingRuleConfiguration toBeAlteredRuleConfig = ShardingTableRuleStatementConverter.convert(rules);
        Collection<String> toBeAlteredLogicTableNames = ShardingTableRuleStatementChecker.getAlteredLogicalTableNames(toBeAlteredRuleConfig);
        Collection toBeAlteredBindingTableNames = toBeAlteredLogicTableNames.stream().filter(bindingTables::contains).collect(Collectors.toSet());
        if (toBeAlteredBindingTableNames.isEmpty()) {
            return;
        }
        ShardingRuleConfiguration toBeCheckedRuleConfig = ShardingTableRuleStatementChecker.createToBeCheckedShardingRuleConfiguration(currentRuleConfig);
        ShardingTableRuleStatementChecker.removeRuleConfiguration(toBeCheckedRuleConfig, toBeAlteredRuleConfig);
        ShardingTableRuleStatementChecker.addRuleConfiguration(toBeCheckedRuleConfig, toBeAlteredRuleConfig);
        Collection<String> dataSourceNames = ShardingTableRuleStatementChecker.getRequiredDataSources(toBeCheckedRuleConfig);
        dataSourceNames.addAll(ShardingTableRuleStatementChecker.getRequiredDataSources(toBeAlteredRuleConfig));
        ShardingSpherePreconditions.checkState((boolean)ShardingTableRuleStatementChecker.check(toBeCheckedRuleConfig, dataSourceNames), () -> new InvalidRuleConfigurationException("sharding table", toBeAlteredLogicTableNames, Collections.singleton("invalid binding table configuration.")));
    }

    private static Collection<String> getCurrentBindingTables(ShardingRuleConfiguration currentRuleConfig) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        currentRuleConfig.getBindingTableGroups().forEach(each -> result.addAll(Splitter.on((String)",").trimResults().splitToList((CharSequence)each.getReference())));
        return result;
    }

    private static void removeRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeAlteredRuleConfig) {
        Collection<String> toBeAlteredLogicTableNames = ShardingTableRuleStatementChecker.getAlteredLogicalTableNames(toBeAlteredRuleConfig);
        toBeAlteredLogicTableNames.forEach(each -> {
            currentRuleConfig.getTables().removeIf(table -> table.getLogicTable().equalsIgnoreCase((String)each));
            currentRuleConfig.getAutoTables().removeIf(table -> table.getLogicTable().equalsIgnoreCase((String)each));
        });
    }

    private static void addRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeAlteredRuleConfig) {
        currentRuleConfig.getTables().addAll(toBeAlteredRuleConfig.getTables());
        currentRuleConfig.getAutoTables().addAll(toBeAlteredRuleConfig.getAutoTables());
        currentRuleConfig.getShardingAlgorithms().putAll(toBeAlteredRuleConfig.getShardingAlgorithms());
        currentRuleConfig.getKeyGenerators().putAll(toBeAlteredRuleConfig.getKeyGenerators());
    }

    private static Collection<String> getAlteredLogicalTableNames(ShardingRuleConfiguration toBeAlteredRuleConfig) {
        Collection result = toBeAlteredRuleConfig.getTables().stream().map(ShardingTableRuleConfiguration::getLogicTable).collect(Collectors.toList());
        result.addAll(toBeAlteredRuleConfig.getAutoTables().stream().map(ShardingAutoTableRuleConfiguration::getLogicTable).collect(Collectors.toList()));
        return result;
    }

    @Generated
    private ShardingTableRuleStatementChecker() {
    }
}

