/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.distsql.handler.query.RQLExecutor;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CountShardingRuleStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class CountShardingRuleExecutor
implements RQLExecutor<CountShardingRuleStatement> {
    public Collection<String> getColumnNames() {
        return Arrays.asList("rule_name", "database", "count");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShardingSphereDatabase database, CountShardingRuleStatement sqlStatement) {
        Optional rule = database.getRuleMetaData().findSingleRule(ShardingRule.class);
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        rule.ifPresent(optional -> this.fillRows((Collection<LocalDataQueryResultRow>)result, (ShardingRule)optional, database.getName()));
        return result;
    }

    private void fillRows(Collection<LocalDataQueryResultRow> result, ShardingRule rule, String databaseName) {
        this.fillRows(result, "sharding_table", databaseName, rule.getTableRules().size());
        this.fillRows(result, "sharding_table_reference", databaseName, ((ShardingRuleConfiguration)rule.getConfiguration()).getBindingTableGroups().size());
    }

    private void fillRows(Collection<LocalDataQueryResultRow> result, String ruleName, String databaseName, int count) {
        result.add(new LocalDataQueryResultRow(new Object[]{ruleName, databaseName, count}));
    }

    public Class<CountShardingRuleStatement> getType() {
        return CountShardingRuleStatement.class;
    }
}

